/*
 * Decompiled with CFR 0.152.
 */
package io.xream.x7.lock;

import io.xream.x7.base.util.ExceptionUtil;
import io.xream.x7.base.util.KeyUtil;
import io.xream.x7.lock.DistributionLock;
import io.xream.x7.lock.Lock;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class LockAspect {
    @Pointcut(value="@annotation(io.xream.x7.lock.Lock))")
    public void cut() {
    }

    @Around(value="cut() && @annotation(lock) ")
    public Object around(ProceedingJoinPoint proceedingJoinPoint, Lock lock) {
        Signature signature = proceedingJoinPoint.getSignature();
        MethodSignature ms = (MethodSignature)signature;
        String prefix = signature.toString();
        String suffix = "~lock";
        String condition = lock.condition();
        Object[] args = proceedingJoinPoint.getArgs();
        String key = KeyUtil.makeKey((String)prefix, (String)"~lock", (String)condition, (Method)ms.getMethod(), (Object[])args);
        int interval = lock.interval();
        int timeout = lock.timeout();
        boolean abortingIfNoLock = lock.abortingIfNoLock();
        return DistributionLock.by(key).lock(interval, timeout, abortingIfNoLock, task -> {
            Class returnType = ms.getReturnType();
            try {
                if (returnType == Void.TYPE) {
                    proceedingJoinPoint.proceed();
                    return null;
                }
                return proceedingJoinPoint.proceed();
            }
            catch (Throwable e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(ExceptionUtil.getMessage((Throwable)e));
            }
        });
    }
}

