/*
 * Decompiled with CFR 0.152.
 */
package io.xream.x7.repository.id;

import io.xream.internal.util.VerifyUtil;
import io.xream.sqli.api.BaseRepository;
import io.xream.sqli.api.ResultMapRepository;
import io.xream.sqli.builder.Criteria;
import io.xream.sqli.builder.CriteriaBuilder;
import io.xream.sqli.builder.ReduceType;
import io.xream.sqli.parser.BeanElement;
import io.xream.sqli.parser.Parsed;
import io.xream.sqli.parser.Parser;
import io.xream.sqli.spi.IdGeneratorProxy;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;

public interface IdGeneratorService
extends IdGeneratorProxy {
    public static final String ID_MAP_KEY = "ID_MAP_KEY";

    public Logger getLogger();

    public StringRedisTemplate getStringRedisTemplate();

    default public void onStart(List<BaseRepository> repositoryList) {
        if (repositoryList == null) {
            return;
        }
        long startTme = System.currentTimeMillis();
        this.getLogger().info("x7-repo/x7-id-generator starting.... \n");
        String idGeneratorScript = "local hk = KEYS[1] local key = KEYS[2] local id = ARGV[1] local existId = redis.call('hget',hk,key) if tonumber(existId) == nil then existId = '0' end if tonumber(id) > tonumber(existId) then redis.call('hset',hk,key,tostring(id)) return tonumber(id) end return tonumber(existId)";
        DefaultRedisScript<Long> redisScript = new DefaultRedisScript<Long>(){

            public String getSha1() {
                return VerifyUtil.toMD5((String)"id_map_key");
            }

            public Class<Long> getResultType() {
                return Long.class;
            }

            public String getScriptAsString() {
                return "local hk = KEYS[1] local key = KEYS[2] local id = ARGV[1] local existId = redis.call('hget',hk,key) if tonumber(existId) == nil then existId = '0' end if tonumber(id) > tonumber(existId) then redis.call('hset',hk,key,tostring(id)) return tonumber(id) end return tonumber(existId)";
            }
        };
        for (BaseRepository baseRepository : repositoryList) {
            String key;
            Parsed parsed;
            BeanElement be;
            CriteriaBuilder.ResultMapBuilder builder = CriteriaBuilder.resultMapBuilder();
            Class clzz = baseRepository.getClzz();
            if (clzz == Void.class || (be = (parsed = Parser.get((Class)clzz)).getElement(key = parsed.getKey())).getClz() == String.class || be.getClz() == Date.class || be.getClz() == Timestamp.class) continue;
            builder.reduce(ReduceType.MAX, be.getProperty()).paged().ignoreTotalRows();
            Criteria.ResultMapCriteria resultMapCriteria = builder.build();
            Collection idList = null;
            if (baseRepository instanceof ResultMapRepository) {
                ResultMapRepository resultMapRepository = (ResultMapRepository)baseRepository;
                idList = resultMapRepository.listPlainValue(Long.class, resultMapCriteria);
            }
            Long maxId = idList.stream().filter(id -> id != null).findFirst().orElse(0L);
            String name = baseRepository.getClzz().getName();
            this.getLogger().info("Db    : " + name + ".maxId = " + maxId);
            List<String> keys = Arrays.asList(ID_MAP_KEY, name);
            long result = (Long)this.getStringRedisTemplate().execute((RedisScript)redisScript, keys, new Object[]{String.valueOf(maxId)});
            this.getLogger().info("Redis : " + name + ".maxId = " + result);
        }
        this.getLogger().info("..................................................");
        long endTime = System.currentTimeMillis();
        this.getLogger().info("x7-repo/x7-id-generator started, cost time: " + (endTime - startTme) + "ms\n\n");
    }
}

