/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.xream.x7.repository.id;


import io.xream.sqli.spi.IdGeneratorProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;

/**
 * @Author Sim
 */
public final class DefaultIdGeneratorService implements IdGeneratorService {

    private Logger logger = LoggerFactory.getLogger(IdGeneratorProxy.class);

    private StringRedisTemplate stringRedisTemplate;

    public DefaultIdGeneratorService(StringRedisTemplate stringRedisTemplate) {
        this.stringRedisTemplate = stringRedisTemplate;
    }

    @Override
    public Logger getLogger(){
        return logger;
    }
    @Override
    public StringRedisTemplate getStringRedisTemplate(){
        return stringRedisTemplate;
    }

    @Override
    public long createId(String clzName) {
        return this.stringRedisTemplate.opsForHash().increment(ID_MAP_KEY,clzName,1);
    }

}
