/*
 * Decompiled with CFR 0.152.
 */
package x7.core.template;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import x7.core.bean.KV;
import x7.core.template.ITemplateable;

public class Templates {
    private static final Map<Class<? extends ITemplateable>, Map<Object, ITemplateable>> templatesMap = new ConcurrentHashMap<Class<? extends ITemplateable>, Map<Object, ITemplateable>>();
    private static final Map<Class<? extends ITemplateable>, List<KV>> schemaMap = new ConcurrentHashMap<Class<? extends ITemplateable>, List<KV>>();

    public static <T> T get(Class<T> clz, Object templateId) {
        Map<Object, ITemplateable> templateMap = templatesMap.get(clz);
        if (templateMap == null) {
            return null;
        }
        return (T)templateMap.get(templateId);
    }

    public static <T> Map<Object, T> get(Class<T> clz) {
        return templatesMap.get(clz);
    }

    public static void clear() {
        templatesMap.clear();
    }

    public static Map<Object, ITemplateable> createOrGet(Class<? extends ITemplateable> clz) {
        Map<Object, ITemplateable> map = templatesMap.get(clz);
        if (map == null) {
            map = new HashMap<Object, ITemplateable>();
            templatesMap.put(clz, map);
        }
        return map;
    }

    public static void put(Class<? extends ITemplateable> clz, Map<Object, ITemplateable> map) {
        templatesMap.put(clz, map);
    }

    public static void put(Class<? extends ITemplateable> key, List<KV> value) {
        schemaMap.put(key, value);
    }

    public static List<KV> getSchema(Class<? extends ITemplateable> key) {
        return schemaMap.get(key);
    }
}

