/*
 * Decompiled with CFR 0.152.
 */
package x7.config;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import x7.core.util.ExceptionUtil;

public class SpringHelper
implements ApplicationContextAware {
    private static Logger logger = LoggerFactory.getLogger(SpringHelper.class);
    private static ApplicationContext applicationContext;
    private static Map<Method, String> mappingMap;

    public void setApplicationContext(ApplicationContext arg0) throws BeansException {
        applicationContext = arg0;
        SpringHelper.getMapPaths();
        System.out.println("\n");
        logger.info("SpringHelper started, static methods[getContext,getObject,getRequestMapping] ");
    }

    public static Object getObject(String beanName) {
        if (applicationContext == null) {
            return null;
        }
        Object object = null;
        try {
            object = applicationContext.getBean(beanName);
        }
        catch (Exception e) {
            System.out.println("_________" + ExceptionUtil.getMessage((Exception)e));
        }
        return object;
    }

    public static ApplicationContext getContext() {
        return applicationContext;
    }

    public static <T> T getObject(Class<T> clazz) {
        if (applicationContext == null) {
            return null;
        }
        try {
            return (T)applicationContext.getBean(clazz);
        }
        catch (Exception e) {
            logger.error(ExceptionUtil.getMessage((Exception)e));
            return null;
        }
    }

    public static String getRequestMapping(Method method) {
        return mappingMap.get(method);
    }

    private static void getMapPaths() {
        RequestMappingHandlerMapping rmhp = SpringHelper.getObject(RequestMappingHandlerMapping.class);
        if (rmhp != null) {
            Map map = rmhp.getHandlerMethods();
            for (RequestMappingInfo info : map.keySet()) {
                String mapping = info.getPatternsCondition().toString().replace("[", "").replace("]", "");
                HandlerMethod hm = (HandlerMethod)map.get(info);
                mappingMap.put(hm.getMethod(), mapping);
            }
        }
    }

    static {
        mappingMap = new HashMap<Method, String>();
    }
}

