/*
 * Decompiled with CFR 0.152.
 */
package x7.core.config;

import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.env.Environment;
import x7.core.util.KeyUtil;

public class Configs {
    private static Map<String, Object> map = new ConcurrentHashMap<String, Object>();
    private static Environment environment;

    public static void setEnvironment(Environment env) {
        environment = env;
    }

    public static Map<String, Object> referMap() {
        return map;
    }

    public static Object get(String keyStr) {
        String envObj = environment.getProperty(keyStr);
        if (Objects.nonNull(envObj)) {
            return envObj;
        }
        List keyList = KeyUtil.getKeyList((String)keyStr);
        Map tempMap = map;
        for (String key : keyList) {
            Object obj = tempMap.get(key);
            if (obj == null) {
                return null;
            }
            if (obj instanceof Map) {
                tempMap = (Map)obj;
                continue;
            }
            return obj;
        }
        return tempMap;
    }

    public static int getIntValue(String key) {
        String envObj = environment.getProperty(key);
        if (Objects.nonNull(envObj)) {
            return Integer.valueOf(envObj);
        }
        Integer value = 0;
        try {
            value = Integer.valueOf(Configs.get(key) + "");
        }
        catch (MissingResourceException mre) {
            String err = "\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6config/*.txt, \u7f3a\u5c11key:" + key;
            System.err.println(err);
            mre.printStackTrace();
        }
        catch (Exception e) {
            String err = "\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6config/*.txt, \u53d1\u73b0\u4e86:" + key + "=" + map.get(key);
            System.err.println(err);
            e.printStackTrace();
        }
        return value;
    }

    public static Map<String, Object> getMap(String key) {
        Object obj = Configs.get(key);
        if (obj instanceof Map) {
            return (Map)obj;
        }
        return null;
    }

    public static String getString(String key) {
        String envObj = environment.getProperty(key);
        if (Objects.nonNull(envObj)) {
            return envObj;
        }
        String value = "";
        try {
            value = Configs.get(key) + "";
        }
        catch (MissingResourceException mre) {
            String err = "\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6config/*.txt, \u7f3a\u5c11key:" + key;
            System.err.println(err);
            mre.printStackTrace();
        }
        catch (Exception e) {
            String err = "\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6config/*.txt, \u53d1\u73b0\u4e86:" + key + "=" + map.get(key);
            System.err.println(err);
            e.printStackTrace();
        }
        return value;
    }

    public static long getLongValue(String key) {
        String envObj = environment.getProperty(key);
        if (Objects.nonNull(envObj)) {
            return Long.valueOf(envObj);
        }
        Long value = 0L;
        try {
            value = Long.valueOf(Configs.get(key) + "");
        }
        catch (MissingResourceException mre) {
            String err = "\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6config/*.txt, \u7f3a\u5c11key:" + key;
            System.err.println(err);
            mre.printStackTrace();
        }
        catch (Exception e) {
            String err = "\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6config/*.txt, \u53d1\u73b0\u4e86:" + key + "=" + map.get(key);
            System.err.println(err);
            e.printStackTrace();
        }
        return value;
    }

    public static boolean isTrue(String key) {
        String envObj = environment.getProperty(key);
        if (Objects.nonNull(envObj)) {
            return Boolean.parseBoolean(envObj);
        }
        String value = "";
        try {
            value = Configs.get(key) + "";
            return Boolean.parseBoolean(value);
        }
        catch (MissingResourceException mre) {
            String err = "\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6config/*.txt, \u7f3a\u5c11key:" + key;
            System.err.println(err);
            mre.printStackTrace();
        }
        catch (Exception e) {
            String err = "\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6config/*.txt, \u53d1\u73b0\u4e86:" + key + "=" + map.get(key);
            System.err.println(err);
            e.printStackTrace();
        }
        return false;
    }

    public static class Inner {
        public static boolean isDev = false;
    }
}

