/*
 * Decompiled with CFR 0.152.
 */
package x7.config.excel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import x7.core.bean.KV;
import x7.core.template.ITemplateable;
import x7.core.template.Templates;

public class ExcelParser {
    private Map<String, Map<String, Class<? extends ITemplateable>>> fileSheetClassMap = new HashMap<String, Map<String, Class<? extends ITemplateable>>>();
    private Map<String, List<String>> fileSheetNameClassMap = new HashMap<String, List<String>>();
    private Map<String, Long> lastModefyTimeMap = new HashMap<String, Long>();
    private static long configLastModifiedTime = 0L;
    private List<String> fileNames = new ArrayList<String>();
    private static ExcelParser instance = null;

    public static ExcelParser getInstance() {
        if (instance == null) {
            instance = new ExcelParser();
        }
        return instance;
    }

    public void load() {
        try {
            this.init();
            this.parse();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ExcelParser() {
    }

    public void init() throws Exception {
        File configFile = new File("/");
        if (configFile.lastModified() <= configLastModifiedTime) {
            return;
        }
        configLastModifiedTime = configFile.lastModified();
        FileInputStream in = new FileInputStream(configFile);
        SAXBuilder builder = new SAXBuilder(false);
        Document doc = builder.build((InputStream)in);
        Element configRoot = doc.getRootElement();
        List configList = configRoot.getChildren("book");
        this.fileNames.clear();
        for (Object configObject : configList) {
            Element configItem = (Element)configObject;
            String fileName = configItem.getAttributeValue("name");
            this.fileNames.add(fileName);
            HashMap sheetClassMap = new HashMap();
            ArrayList<String> sheetNameList = new ArrayList<String>();
            this.fileSheetClassMap.put(fileName, sheetClassMap);
            this.fileSheetNameClassMap.put(fileName, sheetNameList);
            List sheetElementList = configItem.getChildren("sheet");
            for (Element sheetE : sheetElementList) {
                String sheetName = sheetE.getAttributeValue("name");
                try {
                    Class<?> clz = Class.forName(sheetE.getAttributeValue("type"));
                    sheetClassMap.put(sheetName, clz);
                    sheetNameList.add(sheetName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void parse() throws Exception {
        File folder = new File("/");
        if (folder.listFiles() == null) {
            return;
        }
        HashMap<String, File> files = new HashMap<String, File>();
        for (File file : folder.listFiles()) {
            Long lastModifyTime = this.lastModefyTimeMap.get(file.getName());
            if (lastModifyTime != null && file.lastModified() <= lastModifyTime) continue;
            this.lastModefyTimeMap.put(file.getName(), file.lastModified());
            files.put(file.getName(), file);
        }
        for (String fileName : this.fileNames) {
            File file = (File)files.get(fileName);
            if (file == null) continue;
            if (fileName.contains(".xls")) {
                Map<String, Class<? extends ITemplateable>> sheetClassMap = this.fileSheetClassMap.get(fileName);
                if (sheetClassMap == null) {
                    try {
                        System.err.println("\u914d\u7f6e\u6587\u4ef6 (config/excel.xml) \u6ca1\u627e\u5230 (" + fileName + ") \u7684\u914d\u7f6e\u4fe1\u606f");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                Workbook workbook = null;
                try {
                    workbook = Workbook.getWorkbook((File)file);
                }
                catch (Exception e) {
                    System.out.println("EXCEL\u6587\u4ef6 (" + fileName + ") \u5904\u7406\u51fa\u9519");
                    e.printStackTrace();
                    continue;
                }
                Sheet[] sheets = workbook.getSheets();
                HashMap<String, Sheet> sheetMap = new HashMap<String, Sheet>();
                for (Sheet sheet : sheets) {
                    sheetMap.put(sheet.getName(), sheet);
                }
                List<String> sheetNames = this.fileSheetNameClassMap.get(fileName);
                for (String sheetName : sheetNames) {
                    Sheet sheet;
                    sheet = (Sheet)sheetMap.get(sheetName);
                    if (sheet == null) continue;
                    Class<? extends ITemplateable> clz = sheetClassMap.get(sheetName);
                    if (clz == null) {
                        try {
                            System.err.println("\u914d\u7f6e\u6587\u4ef6 (config/excel.xml) \u6ca1\u627e\u5230 (" + fileName + ") \u91cc\u5de5\u4f5c\u8868  (" + sheetName + ")\u7684\u914d\u7f6e\u4fe1\u606f");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    HashMap<Object, ITemplateable> beans = new HashMap<Object, ITemplateable>();
                    int rows = sheet.getRows();
                    int startLine = 2;
                    Cell[] rowNames = sheet.getRow(1);
                    HashMap<String, Integer> nameMap = new HashMap<String, Integer>();
                    int i = 0;
                    for (Cell cell : rowNames) {
                        String name = cell.getContents().trim();
                        if (name != null && !name.equals("")) {
                            nameMap.put(name, i);
                        }
                        ++i;
                    }
                    for (i = startLine; i < rows; ++i) {
                        Cell[] rowArr = sheet.getRow(i);
                        ITemplateable bean = clz.newInstance();
                        ExcelParser.parse(bean, rowArr, nameMap);
                        System.out.println(bean);
                        beans.put(bean.getTemplateId(), bean);
                    }
                    System.out.println("Excel, clz = " + clz + ", beans = " + beans);
                    Templates.put(clz, beans);
                    Cell[] nameCells = sheet.getRow(0);
                    Cell[] propertyCells = sheet.getRow(1);
                    ArrayList<KV> schemaList = new ArrayList<KV>();
                    int length = nameCells.length;
                    for (int j = 0; j < length; ++j) {
                        String k = propertyCells[j].getContents().trim();
                        String v = nameCells[j].getContents().trim();
                        KV kv = new KV(k, (Object)v);
                        schemaList.add(kv);
                    }
                    Templates.put(clz, schemaList);
                }
            }
            System.out.println("-----------");
        }
    }

    private static void parse(ITemplateable bean, Cell[] rowArr, Map<String, Integer> propertyMap) {
        Field[] fieldArr = bean.getClass().getDeclaredFields();
        int rows = rowArr.length;
        try {
            block22: for (Field field : fieldArr) {
                Integer index = propertyMap.get(field.getName());
                if (index == null || index >= rows) continue;
                String str = rowArr[index].getContents();
                if (str == null || str.trim().equals("")) {
                    str = "";
                }
                switch (field.getType().getSimpleName().toLowerCase()) {
                    case "int": {
                        bean.getClass().getDeclaredMethod(ExcelParser.getSetter(field.getName()), Integer.TYPE).invoke((Object)bean, str.equals("") ? 0 : Integer.valueOf(str));
                        continue block22;
                    }
                    case "long": {
                        bean.getClass().getDeclaredMethod(ExcelParser.getSetter(field.getName()), Long.TYPE).invoke((Object)bean, str.equals("") ? 0L : Long.valueOf(str));
                        continue block22;
                    }
                    case "double": {
                        bean.getClass().getDeclaredMethod(ExcelParser.getSetter(field.getName()), Double.TYPE).invoke((Object)bean, str.equals("") ? 0.0 : Double.valueOf(str));
                        continue block22;
                    }
                    case "float": {
                        bean.getClass().getDeclaredMethod(ExcelParser.getSetter(field.getName()), Double.TYPE).invoke((Object)bean, Float.valueOf(str.equals("") ? 0.0f : Float.valueOf(str).floatValue()));
                        continue block22;
                    }
                    case "bigdecimal": {
                        bean.getClass().getDeclaredMethod(ExcelParser.getSetter(field.getName()), BigDecimal.class).invoke((Object)bean, str.equals("") ? new BigDecimal(0) : new BigDecimal(str));
                        continue block22;
                    }
                    case "string": {
                        bean.getClass().getDeclaredMethod(ExcelParser.getSetter(field.getName()), String.class).invoke((Object)bean, str);
                        continue block22;
                    }
                    case "boolean": {
                        bean.getClass().getDeclaredMethod(ExcelParser.getSetter(field.getName()), Boolean.TYPE).invoke((Object)bean, str.equals("1"));
                        continue block22;
                    }
                    case "date": {
                        bean.getClass().getDeclaredMethod(ExcelParser.getSetter(field.getName()), Boolean.TYPE).invoke((Object)bean, str.equals("") ? null : new Date(Long.valueOf(str)));
                        continue block22;
                    }
                    default: {
                        bean.getClass().getDeclaredMethod(ExcelParser.getSetter(field.getName()), String.class).invoke((Object)bean, str);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getSetter(String name) {
        if (name.startsWith("is")) {
            String rest = name.substring(2);
            return "set" + rest;
        }
        String a = name.substring(0, 1);
        String rest = name.substring(1);
        return "set" + a.toUpperCase() + rest;
    }

    public static class Import {
        public static ExcelBuilder build() {
            ExcelBuilder excel = new ExcelBuilder();
            return excel;
        }

        public static class ExcelBuilder {
            private Map<Class<? extends ITemplateable>, List<? extends ITemplateable>> templateMap = new HashMap<Class<? extends ITemplateable>, List<? extends ITemplateable>>();

            public ExcelBuilder add(Class<? extends ITemplateable> clz) {
                this.templateMap.put(clz, new ArrayList());
                return this;
            }

            public Map<Class<? extends ITemplateable>, List<? extends ITemplateable>> read(String filePath) {
                Sheet[] sheets;
                File file = new File(filePath);
                Workbook workbook = null;
                try {
                    workbook = Workbook.getWorkbook((File)file);
                }
                catch (Exception e) {
                    System.out.println("EXCEL\u6587\u4ef6 (" + file + ") \u5904\u7406\u51fa\u9519");
                    e.printStackTrace();
                }
                for (Sheet sheet : sheets = workbook.getSheets()) {
                    if (sheet == null) continue;
                    Class<? extends ITemplateable> clz = null;
                    for (Class<? extends ITemplateable> clzz : this.templateMap.keySet()) {
                        if (!clzz.getSimpleName().equals(sheet.getName())) continue;
                        clz = clzz;
                        break;
                    }
                    if (clz == null) continue;
                    List<? extends ITemplateable> list = this.templateMap.get(clz);
                    int rows = sheet.getRows();
                    int startLine = 2;
                    Cell[] propertyNameCellArr = sheet.getRow(1);
                    HashMap<String, Integer> propertyMap = new HashMap<String, Integer>();
                    int i = 0;
                    for (Cell cell : propertyNameCellArr) {
                        String name = cell.getContents().trim();
                        if (name != null && !name.equals("")) {
                            propertyMap.put(name, i);
                        }
                        ++i;
                    }
                    for (i = startLine; i < rows; ++i) {
                        Cell[] rowArr = sheet.getRow(i);
                        ITemplateable bean = null;
                        try {
                            bean = clz.newInstance();
                        }
                        catch (IllegalAccessException | InstantiationException e) {
                            e.printStackTrace();
                        }
                        ExcelParser.parse(bean, rowArr, propertyMap);
                        if (bean.getTemplateId() == null || Integer.valueOf(bean.getTemplateId().toString()) == 0) {
                            bean.setTemplateId(i + 1);
                        }
                        System.out.println(bean);
                        list.add(bean);
                    }
                    try {
                        if (workbook == null) continue;
                        workbook.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return this.templateMap;
            }
        }
    }

    public static class Export {
        public static Excel build(Class<? extends ITemplateable> clz, List<? extends ITemplateable> dataList) {
            Excel excel = new Excel();
            excel.clz = clz;
            excel.dataList = dataList;
            return excel;
        }

        public static class Excel {
            private Class<? extends ITemplateable> clz;
            private List<? extends ITemplateable> dataList;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(String filePath) {
                System.out.println("clz = " + this.clz);
                System.out.println("dataList = " + this.dataList);
                System.out.println("\u88c5\u903c\u7684EXCEL\u5bfc\u51fa => " + filePath);
                File file = new File(filePath);
                WritableWorkbook workbook = null;
                try {
                    workbook = Workbook.createWorkbook((File)file);
                    WritableSheet sheet = workbook.createSheet(this.clz.getSimpleName(), 0);
                    int r = 0;
                    int c = 0;
                    List<KV> tagList = Templates.getSchema(this.clz);
                    if (Objects.nonNull(tagList)) {
                        for (KV kV : tagList) {
                            sheet.addCell((WritableCell)new Label(c++, r, kV.v.toString()));
                        }
                    }
                    ++r;
                    for (ITemplateable iTemplateable : this.dataList) {
                        c = 0;
                        if (Objects.nonNull(tagList)) {
                            for (KV kv : tagList) {
                                Field f = this.clz.getDeclaredField(kv.k);
                                f.setAccessible(true);
                                Object v = f.get(iTemplateable);
                                if (Objects.isNull(v)) {
                                    ++c;
                                    continue;
                                }
                                sheet.addCell((WritableCell)new Label(c++, r, v.toString()));
                            }
                        } else {
                            Field[] fArr;
                            for (Field f : fArr = this.clz.getDeclaredFields()) {
                                f.setAccessible(true);
                                Object v = f.get(iTemplateable);
                                if (Objects.isNull(v)) {
                                    ++c;
                                    continue;
                                }
                                sheet.addCell((WritableCell)new Label(c++, r, v.toString()));
                            }
                        }
                        ++r;
                    }
                    workbook.write();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        if (workbook != null) {
                            workbook.close();
                        }
                    }
                    catch (WriteException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(String filePath, Headline headline, Footer footer) {
                System.out.println("clz = " + this.clz);
                System.out.println("dataList = " + this.dataList);
                System.out.println("\u88c5\u903c\u7684EXCEL\u5bfc\u51fa => " + filePath);
                File file = new File(filePath);
                WritableWorkbook workbook = null;
                try {
                    List<KV> tagList;
                    workbook = Workbook.createWorkbook((File)file);
                    WritableSheet sheet = workbook.createSheet(this.clz.getSimpleName(), 0);
                    int r = 0;
                    int c = 0;
                    if (headline != null) {
                        r += headline.addTo((Sheet)sheet);
                    }
                    if (Objects.nonNull(tagList = Templates.getSchema(this.clz))) {
                        for (KV kV : tagList) {
                            sheet.addCell((WritableCell)new Label(c++, r, kV.v.toString()));
                        }
                    }
                    ++r;
                    for (ITemplateable iTemplateable : this.dataList) {
                        c = 0;
                        if (Objects.nonNull(tagList)) {
                            for (KV kv : tagList) {
                                Field f = this.clz.getDeclaredField(kv.k);
                                f.setAccessible(true);
                                Object v = f.get(iTemplateable);
                                if (Objects.isNull(v)) {
                                    ++c;
                                    continue;
                                }
                                sheet.addCell((WritableCell)new Label(c++, r, v.toString()));
                            }
                        } else {
                            Field[] fArr;
                            for (Field f : fArr = this.clz.getDeclaredFields()) {
                                f.setAccessible(true);
                                Object v = f.get(iTemplateable);
                                if (Objects.isNull(v)) {
                                    ++c;
                                    continue;
                                }
                                sheet.addCell((WritableCell)new Label(c++, r, v.toString()));
                            }
                        }
                        ++r;
                    }
                    if (footer != null) {
                        footer.addTo(r, (Sheet)sheet);
                    }
                    workbook.write();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        if (workbook != null) {
                            workbook.close();
                        }
                    }
                    catch (WriteException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }

            public static interface Footer {
                public int addTo(int var1, Sheet var2);
            }

            public static interface Headline {
                public int addTo(Sheet var1);
            }
        }
    }
}

