/*
 * Decompiled with CFR 0.152.
 */
package x7.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import x7.core.config.Configs;
import x7.core.util.KeyUtil;
import x7.core.util.StringUtil;

public class TextParser {
    private static TextParser instance = null;
    private static String[] configFileSuffixArr = new String[]{".txt", ".cfg", ".properties", ".cnf"};
    private Map<String, Object> map = null;

    public static TextParser getInstance() {
        if (instance == null) {
            instance = new TextParser();
        }
        return instance;
    }

    private TextParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readConfig(JarFile jf, JarEntry je) {
        try {
            InputStream is = jf.getInputStream(je);
            BufferedReader br = null;
            try {
                br = new BufferedReader(new InputStreamReader(is, "utf-8"));
                String dataStr = "";
                String key = null;
                String value = null;
                while ((dataStr = br.readLine()) != null) {
                    if (dataStr.startsWith("#")) continue;
                    if (dataStr.contains("=")) {
                        this.put(key, value);
                        key = null;
                        value = null;
                        key = dataStr.substring(0, dataStr.indexOf("=")).trim();
                        value = dataStr.substring(dataStr.indexOf("=") + 1);
                        continue;
                    }
                    if (StringUtil.isNullOrEmpty((String)dataStr) || dataStr.equals("\n")) continue;
                    value = value + "\n";
                    value = value + dataStr;
                }
                this.put(key, value);
                key = null;
                value = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    br.close();
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void load(String[] ativeProfiles) {
        this.map = Configs.referMap();
        String path = this.getClass().getClassLoader().getResource("").getPath();
        if (path.contains(".jar")) {
            String[] arr = path.split(":");
            String real = arr[1];
            String[] pathFolder = real.split("!");
            String jarPath = pathFolder[0];
            String jarFolder = pathFolder[1];
            jarFolder = jarFolder.substring(1);
            String testPathTag = "test-classes";
            String appPathTag = "classes";
            if (jarFolder.contains("test-classes")) {
                jarFolder = jarFolder.replace("test-classes", "classes");
            }
            try {
                JarFile jarFile = new JarFile(jarPath);
                Enumeration<JarEntry> es = jarFile.entries();
                block6: while (es.hasMoreElements()) {
                    JarEntry j = es.nextElement();
                    String name = j.getName();
                    if (!name.startsWith(jarFolder)) continue;
                    name = name.replace(jarFolder, "");
                    boolean ignored = true;
                    for (String suffix : configFileSuffixArr) {
                        if (!name.endsWith(suffix)) continue;
                        ignored = false;
                        break;
                    }
                    if (ignored) continue;
                    if (ativeProfiles == null || ativeProfiles.length == 0) {
                        System.out.println("\n[" + name + "]");
                        this.readConfig(jarFile, j);
                        continue;
                    }
                    if (name.equals("application.properties")) continue;
                    if (!name.contains("-")) {
                        System.out.println("\n[" + name + "]");
                        this.readConfig(jarFile, j);
                        continue;
                    }
                    for (String profile : ativeProfiles) {
                        if (!name.contains("-" + profile + ".")) continue;
                        System.out.println("\n[" + name + "]");
                        this.readConfig(jarFile, j);
                        continue block6;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                String testPathTag = "test-classes";
                String appPathTag = "classes";
                if (path.contains("test-classes")) {
                    path = path.replace("test-classes", "classes");
                }
                instance.readConfigs(path, ativeProfiles);
            }
            catch (Exception e) {
                e.printStackTrace();
                String notes = "\u65e0\u6cd5\u542f\u52a8";
                System.err.println("\n" + notes + "\n");
                String err = "\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u51fa\u9519,\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6config/*.txt";
                System.err.println(err + "\n");
                try {
                    Thread.sleep(20000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public int getIntValue(String key) {
        Integer value = 0;
        try {
            value = Integer.valueOf(this.map.get(key) + "");
        }
        catch (MissingResourceException mre) {
            String err = "\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6config/*.txt, \u7f3a\u5c11key:" + key;
            System.err.println(err);
            mre.printStackTrace();
        }
        catch (Exception e) {
            String err = "\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6config/*.txt, \u53d1\u73b0\u4e86:" + key + "=" + this.map.get(key);
            System.err.println(err);
            e.printStackTrace();
        }
        return value;
    }

    public String getString(String key) {
        String value = "";
        try {
            value = this.map.get(key) + "";
        }
        catch (MissingResourceException mre) {
            String err = "\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6config/*.txt, \u7f3a\u5c11key:" + key;
            System.err.println(err);
            mre.printStackTrace();
        }
        catch (Exception e) {
            String err = "\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6config/*.txt, \u53d1\u73b0\u4e86:" + key + "=" + this.map.get(key);
            System.err.println(err);
            e.printStackTrace();
        }
        return value;
    }

    public long getLongValue(String key) {
        Long value = 0L;
        try {
            value = Long.valueOf(this.map.get(key) + "");
        }
        catch (MissingResourceException mre) {
            String err = "\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6config/*.txt, \u7f3a\u5c11key:" + key;
            System.err.println(err);
            mre.printStackTrace();
        }
        catch (Exception e) {
            String err = "\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6config/*.txt, \u53d1\u73b0\u4e86:" + key + "=" + this.map.get(key);
            System.err.println(err);
            e.printStackTrace();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readConfig(String path) {
        FileInputStream fis = null;
        BufferedReader br = null;
        try {
            fis = new FileInputStream(path);
            br = new BufferedReader(new InputStreamReader((InputStream)fis, "utf-8"));
            String dataStr = "";
            String key = null;
            String value = null;
            while ((dataStr = br.readLine()) != null) {
                if (dataStr.startsWith("#")) continue;
                if (dataStr.contains("=")) {
                    this.put(key, value);
                    key = null;
                    value = null;
                    key = dataStr.substring(0, dataStr.indexOf("=")).trim();
                    value = dataStr.substring(dataStr.indexOf("=") + 1);
                    continue;
                }
                if (StringUtil.isNullOrEmpty((String)dataStr) || dataStr.equals("\n")) continue;
                value = value + "\n";
                value = value + dataStr;
            }
            this.put(key, value);
            key = null;
            value = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                br.close();
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void put(String key, String value) {
        if (key != null) {
            System.out.println(key + "=" + value);
            value = value.trim();
            if (key.contains(".")) {
                List keyList = KeyUtil.getKeyList((String)key);
                int size = keyList.size();
                Map mapObject = this.map;
                int length = size - 1;
                for (int i = 0; i < length; ++i) {
                    String k = (String)keyList.get(i);
                    ConcurrentHashMap o = mapObject.get(k);
                    if (o == null) {
                        o = new ConcurrentHashMap();
                        mapObject.put(k, o);
                    }
                    if (mapObject instanceof Map) {
                        mapObject = o;
                        continue;
                    }
                    System.err.println("_________Config unhappy for x7-config's map:  key = " + k);
                }
                if (mapObject instanceof Map) {
                    mapObject.put(keyList.get(length), (Object)value);
                } else {
                    System.err.println("_________Config unhappy for x7-config's map:  key = " + (String)keyList.get(length));
                }
            } else {
                this.map.put(key, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readContent(String path) {
        ArrayList<String> list = new ArrayList<String>();
        FileInputStream fis = null;
        BufferedReader br = null;
        try {
            fis = new FileInputStream(path);
            br = new BufferedReader(new InputStreamReader((InputStream)fis, "utf-8"));
            String dataStr = "";
            while ((dataStr = br.readLine()) != null) {
                list.add(dataStr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                br.close();
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeConfig(String path, List<String> data) {
        FileOutputStream fos = null;
        BufferedWriter br = null;
        try {
            fos = new FileOutputStream(path);
            br = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "utf-8"));
            for (String str : data) {
                br.write(str);
                br.newLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                br.flush();
                fos.flush();
                br.close();
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void readConfigs(String path, String[] ativeProfiles) {
        File file = new File(path);
        System.out.println("______path: " + file.getAbsolutePath());
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            block0: for (File childFile : file.listFiles()) {
                if (childFile.isDirectory()) {
                    this.readConfigs(childFile.getPath(), ativeProfiles);
                    continue;
                }
                String name = childFile.getName().toLowerCase();
                boolean ignored = true;
                for (String suffix : configFileSuffixArr) {
                    if (!name.endsWith(suffix)) continue;
                    ignored = false;
                    break;
                }
                if (ignored) continue;
                if (ativeProfiles == null || ativeProfiles.length == 0) {
                    System.out.println("\n[" + name + "]");
                    this.readConfig(childFile.getPath());
                    continue;
                }
                if (name.endsWith("application.properties")) continue;
                if (!name.contains("-")) {
                    System.out.println("\n[" + name + "]");
                    this.readConfig(childFile.getPath());
                    continue;
                }
                for (String profile : ativeProfiles) {
                    if (!name.contains("-" + profile + ".")) continue;
                    System.out.println("\n[" + name + "]");
                    this.readConfig(childFile.getPath());
                    continue block0;
                }
            }
        }
    }
}

