/*
 * Decompiled with CFR 0.152.
 */
package x7.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.concurrent.ConcurrentHashMap;
import x7.core.config.Configs;
import x7.core.util.KeyUtil;
import x7.core.util.StringUtil;

public class TextParser {
    private static TextParser instance = null;
    private Map<String, Object> map = null;

    public static TextParser getInstance() {
        if (instance == null) {
            instance = new TextParser();
        }
        return instance;
    }

    private TextParser() {
    }

    public void load(String localAddress, String configSpace) {
        this.map = Configs.referMap((String)configSpace);
        try {
            this.readConfigs(localAddress + "/" + configSpace, configSpace);
        }
        catch (Exception e) {
            e.printStackTrace();
            String notes = "\u65e0\u6cd5\u542f\u52a8";
            System.err.println("\n" + notes + "\n");
            String err = "\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u51fa\u9519,\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6config/*.txt";
            System.err.println(err + "\n");
            try {
                Thread.sleep(20000L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            System.exit(0);
        }
    }

    public int getIntValue(String key) {
        Integer value = 0;
        try {
            value = Integer.valueOf(this.map.get(key) + "");
        }
        catch (MissingResourceException mre) {
            String err = "\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6config/*.txt, \u7f3a\u5c11key:" + key;
            System.err.println(err);
            mre.printStackTrace();
        }
        catch (Exception e) {
            String err = "\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6config/*.txt, \u53d1\u73b0\u4e86:" + key + "=" + this.map.get(key);
            System.err.println(err);
            e.printStackTrace();
        }
        return value;
    }

    public String getString(String key) {
        String value = "";
        try {
            value = this.map.get(key) + "";
        }
        catch (MissingResourceException mre) {
            String err = "\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6config/*.txt, \u7f3a\u5c11key:" + key;
            System.err.println(err);
            mre.printStackTrace();
        }
        catch (Exception e) {
            String err = "\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6config/*.txt, \u53d1\u73b0\u4e86:" + key + "=" + this.map.get(key);
            System.err.println(err);
            e.printStackTrace();
        }
        return value;
    }

    public long getLongValue(String key) {
        Long value = 0L;
        try {
            value = Long.valueOf(this.map.get(key) + "");
        }
        catch (MissingResourceException mre) {
            String err = "\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6config/*.txt, \u7f3a\u5c11key:" + key;
            System.err.println(err);
            mre.printStackTrace();
        }
        catch (Exception e) {
            String err = "\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6config/*.txt, \u53d1\u73b0\u4e86:" + key + "=" + this.map.get(key);
            System.err.println(err);
            e.printStackTrace();
        }
        return value;
    }

    public void readConfigs(String path, String space) {
        File file = new File(path);
        if (!file.isDirectory() || file.list().length == 0) {
            throw new RuntimeException("CONFIG KEY EXCEPTION: x7.config.localAddress, if relative path unavailable, try absolute path");
        }
        if (file.isDirectory()) {
            for (String childStr : file.list()) {
                if (childStr.endsWith(".txt") || childStr.endsWith(".properties") || childStr.endsWith(".cfg") || childStr.endsWith(".init") || childStr.endsWith(".js") || childStr.endsWith(".json")) {
                    System.out.println("\n[" + space + "/" + childStr + "]");
                    this.readConfig(path + "/" + childStr, space);
                    continue;
                }
                if (childStr.contains(".")) continue;
                if (space == null || space.equals("")) {
                    this.readConfigs(path + "/" + childStr, childStr);
                    continue;
                }
                this.readConfigs(path + "/" + childStr, space + "." + childStr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readConfig(String path, String space) {
        FileInputStream fis = null;
        BufferedReader br = null;
        try {
            fis = new FileInputStream(path);
            br = new BufferedReader(new InputStreamReader((InputStream)fis, "utf-8"));
            String dataStr = "";
            String key = null;
            String value = null;
            while ((dataStr = br.readLine()) != null) {
                if (dataStr.startsWith("#")) continue;
                if (dataStr.contains("=")) {
                    this.put(key, value, space);
                    key = null;
                    value = null;
                    key = dataStr.substring(0, dataStr.indexOf("=")).trim();
                    value = dataStr.substring(dataStr.indexOf("=") + 1);
                    continue;
                }
                if (StringUtil.isNullOrEmpty((String)dataStr) || dataStr.equals("\n")) continue;
                value = value + "\n";
                value = value + dataStr;
            }
            this.put(key, value, space);
            key = null;
            value = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                br.close();
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void put(String key, String value, String space) {
        if (key != null) {
            System.out.println(key + "=" + value);
            if (space != null && !space.equals("")) {
                key = space + "." + key;
            }
            value = value.trim();
            if (key.contains(".")) {
                List keyList = KeyUtil.getKeyList((String)key);
                int size = keyList.size();
                Map mapObject = this.map;
                int length = size - 1;
                for (int i = 0; i < length; ++i) {
                    String k = (String)keyList.get(i);
                    ConcurrentHashMap o = mapObject.get(k);
                    if (o == null) {
                        o = new ConcurrentHashMap();
                        mapObject.put(k, o);
                    }
                    mapObject = o;
                }
                mapObject.put(keyList.get(length), (Object)value);
            } else {
                this.map.put(key, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readContent(String path) {
        ArrayList<String> list = new ArrayList<String>();
        FileInputStream fis = null;
        BufferedReader br = null;
        try {
            fis = new FileInputStream(path);
            br = new BufferedReader(new InputStreamReader((InputStream)fis, "utf-8"));
            String dataStr = "";
            while ((dataStr = br.readLine()) != null) {
                list.add(dataStr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                br.close();
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeConfig(String path, List<String> data) {
        FileOutputStream fos = null;
        BufferedWriter br = null;
        try {
            fos = new FileOutputStream(path);
            br = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "utf-8"));
            for (String str : data) {
                br.write(str);
                br.newLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                br.flush();
                fos.flush();
                br.close();
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

