/*
 * Decompiled with CFR 0.152.
 */
package x7.config;

import x7.config.ConfigKeeper;
import x7.config.TextParser;
import x7.config.zk.ZkBase;
import x7.core.config.Configs;
import x7.core.util.StringUtil;

public class ConfigBuilder {
    private static ConfigBuilder instance;

    public static ConfigBuilder newInstance() {
        if (instance == null) {
            instance = new ConfigBuilder();
        }
        return instance;
    }

    public static void build(boolean centralized, String configSpace, String localAddress, String remoteAddress) {
        if (instance == null) {
            instance = new ConfigBuilder();
            ConfigBuilder.init(centralized, configSpace, localAddress, remoteAddress);
        }
    }

    private static void init(boolean centralized, String configSpace, String localAddress, String remoteAddress) {
        Configs.setConfigSpace((String)configSpace);
        if (StringUtil.isNullOrEmpty((String)remoteAddress) && StringUtil.isNullOrEmpty((String)localAddress)) {
            return;
        }
        if (centralized) {
            if (centralized && StringUtil.isNotNull((String)remoteAddress)) {
                ZkBase.getInstance();
                ZkBase.init(remoteAddress);
                ZkBase.getInstance().add(ConfigKeeper.getInstance());
            }
            return;
        }
        if (StringUtil.isNotNull((String)localAddress)) {
            Configs.localAddress = localAddress;
            TextParser.getInstance().load(localAddress, configSpace);
        } else if (StringUtil.isNotNull((String)remoteAddress)) {
            ZkBase.getInstance();
            ZkBase.init(remoteAddress);
            ZkBase.getInstance().add(ConfigKeeper.getInstance());
        }
    }
}

