/*
 * Decompiled with CFR 0.152.
 */
package x7.config.zk;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import x7.core.config.Configs;
import x7.core.distributed.Keeper;
import x7.core.type.DataEventType;
import x7.core.util.JsonX;
import x7.core.util.KeyUtil;
import x7.core.util.StringUtil;

public class ZkClient {
    private ZooKeeper zk = null;
    private Set<Keeper> keeperSet = new HashSet<Keeper>();
    public static Map<Watcher.Event.EventType, DataEventType> KEY_MAP = new HashMap<Watcher.Event.EventType, DataEventType>(){
        {
            this.put(Watcher.Event.EventType.NodeCreated, DataEventType.CREATE);
            this.put(Watcher.Event.EventType.NodeDataChanged, DataEventType.REFRESH);
            this.put(Watcher.Event.EventType.NodeDeleted, DataEventType.REMOVE);
        }
    };

    public void add(Keeper keeper) {
        this.keeperSet.add(keeper);
    }

    public ZkClient(String zkUrl) {
        try {
            System.out.println("zookeeper url: " + zkUrl);
            this.zk = new ZooKeeper(zkUrl, 500000, new Watcher(){

                public void process(WatchedEvent event) {
                    Watcher.Event.EventType type = event.getType();
                    if (type == null) {
                        return;
                    }
                    DataEventType deType = KEY_MAP.get(type);
                    if (deType == null) {
                        return;
                    }
                    String path = event.getPath();
                    if (StringUtil.isNullOrEmpty((String)path)) {
                        return;
                    }
                    List keyList = KeyUtil.getKeyList((String)path);
                    Object value = null;
                    byte[] byteArr = null;
                    try {
                        if (type != Watcher.Event.EventType.NodeDeleted) {
                            byteArr = ZkClient.this.zk.getData(path, false, null);
                        }
                    }
                    catch (KeeperException e) {
                        e.printStackTrace();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    String str = "";
                    if (byteArr != null) {
                        str = new String(byteArr);
                    }
                    value = str.startsWith("[") ? JsonX.toList((String)str, String.class) : (str.contains("{") || str.contains("[") ? JsonX.toMap((String)str) : str);
                    System.out.println("------------ " + type);
                    for (Keeper keeper : ZkClient.this.keeperSet) {
                        keeper.onChanged(deType, keyList, value);
                    }
                }
            });
            this.zk.exists("/", true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("_________________________________");
        System.out.println("______ZK CLIENT IS WORKING O_____");
        System.out.println("_________________________________");
    }

    public ZkClient(Keeper keeper) {
        this.keeperSet.add(keeper);
        try {
            System.out.println(Configs.getString((String)"ZK_URL"));
            this.zk = new ZooKeeper(Configs.getString((String)"ZK_URL"), 500000, new Watcher(){

                public void process(WatchedEvent event) {
                    Watcher.Event.EventType type = event.getType();
                    if (type == null) {
                        return;
                    }
                    DataEventType deType = KEY_MAP.get(type);
                    if (deType == null) {
                        return;
                    }
                    String path = event.getPath();
                    if (StringUtil.isNullOrEmpty((String)path)) {
                        return;
                    }
                    List keyList = KeyUtil.getKeyList((String)path);
                    Object value = null;
                    byte[] byteArr = null;
                    try {
                        if (type != Watcher.Event.EventType.NodeDeleted) {
                            byteArr = ZkClient.this.zk.getData(path, false, null);
                        }
                    }
                    catch (KeeperException e) {
                        e.printStackTrace();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    String str = "";
                    if (byteArr != null) {
                        str = new String(byteArr);
                    }
                    value = str.startsWith("[") ? JsonX.toList((String)str, String.class) : (str.contains("{") || str.contains("[") ? JsonX.toMap((String)str) : str);
                    System.out.println("------------ " + type);
                    for (Keeper keeper : ZkClient.this.keeperSet) {
                        keeper.onChanged(deType, keyList, value);
                    }
                }
            });
            this.zk.exists("/", true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("_________________________________");
        System.out.println("______ZK CLIENT IS WORKING O_____");
        System.out.println("_________________________________");
    }

    public void create(String path, String value, CreateMode mode) {
        try {
            Stat s = this.zk.exists(path, true);
            if (s == null) {
                this.zk.create(path, value.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, mode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void refresh(String path, String value) {
        try {
            this.zk.setData(path, value.getBytes(), -1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void remove(String path) {
        try {
            List list = this.zk.getChildren(path, true);
            if (list == null || list.isEmpty()) {
                this.zk.delete(path, -1);
                return;
            }
            for (String key : list) {
                System.out.println("remove ---- " + path + "/" + key);
                this.remove(path + "/" + key);
            }
            if (path.indexOf("/", 1) == -1) {
                System.out.println("remove ---- " + path);
                this.zk.delete(path, -1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String get(String path) {
        try {
            byte[] bytes = this.zk.getData(path, true, null);
            if (bytes == null) {
                return null;
            }
            return new String(bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<String> getChildren(String path) {
        try {
            return this.zk.getChildren(path, false);
        }
        catch (InterruptedException | KeeperException throwable) {
            return null;
        }
    }
}

