/*
 * Decompiled with CFR 0.152.
 */
package x7.config;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import x7.core.config.Configs;
import x7.core.distributed.Keeper;
import x7.core.type.DataEventType;

public class ConfigKeeper
implements Keeper {
    private Map<String, Object> map = Configs.referMap(null);
    private static ConfigKeeper instance;

    public static ConfigKeeper getInstance() {
        if (instance == null) {
            instance = new ConfigKeeper();
        }
        return instance;
    }

    public Map<String, Object> getMap() {
        return this.map;
    }

    public void onChanged(DataEventType type, List<String> keyList, Object obj) {
        if (!"configRoot".equals(keyList.get(0))) {
            return;
        }
        keyList.remove(0);
        String configSpace = Configs.getString((String)"x7.config.space");
        if (!configSpace.equals(keyList.get(0))) {
            return;
        }
        keyList.remove(0);
        int size = keyList.size();
        if (size == 0) {
            return;
        }
        Map mapObject = this.map;
        int length = size - 1;
        for (int i = 0; i < length; ++i) {
            String key = keyList.get(i);
            ConcurrentHashMap o = mapObject.get(key);
            if (o == null) {
                o = new ConcurrentHashMap();
                mapObject.put(key, o);
            }
            mapObject = o;
        }
        switch (type) {
            case CREATE: {
                mapObject.put((String)keyList.get(length), (Object)obj);
                break;
            }
            case REFRESH: {
                mapObject.put((String)keyList.get(length), (Object)obj);
                break;
            }
            case REMOVE: {
                mapObject.remove(keyList.get(length));
            }
        }
    }
}

