/*
 * Decompiled with CFR 0.152.
 */
package io.xream.x7.common.repository;

import io.xream.x7.common.bean.FieldAndMethod;
import io.xream.x7.common.util.BeanUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class ReflectionCache {
    private Class clz;
    private Map<String, FieldAndMethod> map = new HashMap<String, FieldAndMethod>();
    private Map<String, FieldAndMethod> tempMap = new HashMap<String, FieldAndMethod>();

    public Class getClz() {
        return this.clz;
    }

    public void setClz(Class clz) {
        this.clz = clz;
    }

    public Map<String, FieldAndMethod> getMap() {
        return this.map;
    }

    public void setMap(Map<String, FieldAndMethod> map) {
        this.map = map;
    }

    public FieldAndMethod get(String property) {
        return this.map.get(property);
    }

    public FieldAndMethod getTemp(String property) {
        return this.tempMap.get(property);
    }

    public Map<String, FieldAndMethod> getTempMap() {
        return this.tempMap;
    }

    public void setTempMap(Map<String, FieldAndMethod> tempMap) {
        this.tempMap = tempMap;
    }

    public void cache() {
        if (this.clz == null) {
            return;
        }
        if (this.map.isEmpty()) {
            Field[] fArr;
            for (Field f : fArr = this.clz.getDeclaredFields()) {
                if (f.getModifiers() > 2) continue;
                String property = f.getName();
                Class<?> type = f.getType();
                String getterName = BeanUtil.getGetter(type, property);
                String setterName = BeanUtil.getSetter(type, property);
                try {
                    Method getter = this.clz.getDeclaredMethod(getterName, new Class[0]);
                    Class<?> rt = f.getType();
                    Method setter = this.clz.getDeclaredMethod(setterName, rt);
                    if (getter == null || setter == null) continue;
                    f.setAccessible(true);
                    FieldAndMethod fnm = new FieldAndMethod();
                    fnm.setProperty(property);
                    fnm.setSetterName(setterName);
                    fnm.setGetterName(getterName);
                    fnm.setField(f);
                    fnm.setGetter(getter);
                    fnm.setSetter(setter);
                    this.map.put(property, fnm);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public String toString() {
        return "ReflectionCache [clz=" + this.clz + ", map=" + this.map + "]";
    }
}

