/*
 * Decompiled with CFR 0.152.
 */
package io.xream.x7.common.bean;

import io.xream.x7.common.bean.BeanElement;
import io.xream.x7.common.bean.Criteria;
import io.xream.x7.common.bean.Parsed;
import io.xream.x7.common.repository.ReflectionCache;
import io.xream.x7.common.repository.X;
import io.xream.x7.common.util.BeanUtil;
import io.xream.x7.common.util.BeanUtilX;
import io.xream.x7.common.util.StringUtil;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parser {
    private static Logger logger = LoggerFactory.getLogger(Parser.class);
    private static final Map<Class, Parsed> map = new ConcurrentHashMap<Class, Parsed>();
    private static final Map<String, Parsed> simpleNameMap = new ConcurrentHashMap<String, Parsed>();
    private static final Map<Class, ReflectionCache> cacheMap = new ConcurrentHashMap<Class, ReflectionCache>();
    public static String mappingPrefix;
    public static String mappingSpec;

    public static void put(Class clz, Parsed parsed) {
        map.put(clz, parsed);
        String key = BeanUtil.getByFirstLower(clz.getSimpleName());
        simpleNameMap.put(key, parsed);
    }

    public static Parsed get(Class clz) {
        Parsed parsed = map.get(clz);
        if (parsed == null) {
            Parser.parse(clz);
            parsed = map.get(clz);
            Field f = parsed.getKeyField(1);
            if (f == null) {
                throw new RuntimeException("No Primary Key, class: " + clz.getName());
            }
        }
        return parsed;
    }

    public static Parsed get(String simpleName) {
        return simpleNameMap.get(simpleName);
    }

    public static void parse(Class clz) {
        boolean isNoSpec;
        Parsed parsed;
        List<BeanElement> elementList;
        block16: {
            if (clz == Criteria.class || clz == Criteria.ResultMappedCriteria.class) {
                throw new RuntimeException("parser unsupport Criteria, CriteriaJoinable, ....");
            }
            elementList = BeanUtilX.getElementList(clz);
            parsed = new Parsed(clz);
            for (BeanElement beanElement : elementList) {
                if (!StringUtil.isNullOrEmpty(beanElement.getMapper())) continue;
                beanElement.initMaper();
            }
            isNoSpec = true;
            try {
                if (StringUtil.isNotNull(mappingSpec)) {
                    isNoSpec = false;
                    break block16;
                }
                for (BeanElement element : elementList) {
                    if (element.getProperty().equals(element.getMapper())) continue;
                    isNoSpec = false;
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        parsed.setNoSpec(isNoSpec);
        parsed.reset(elementList);
        BeanUtilX.parseKey(parsed, clz);
        X.Mapping mapping = clz.getAnnotation(X.Mapping.class);
        if (mapping != null) {
            String tableName = mapping.value();
            if (!tableName.equals("")) {
                parsed.setTableName(tableName);
                parsed.setOriginTable(tableName);
                parsed.setNoSpec(false);
            } else {
                String name = BeanUtil.getByFirstLower(clz.getSimpleName());
                String mapper = BeanUtil.getMapper(name);
                String prefix = mappingPrefix;
                if (StringUtil.isNotNull(prefix)) {
                    if (!prefix.endsWith("_")) {
                        prefix = prefix + "_";
                    }
                    mapper = prefix + mapper;
                }
                parsed.setTableName(mapper);
                parsed.setOriginTable(mapper);
            }
        } else {
            String name = BeanUtil.getByFirstLower(clz.getSimpleName());
            String mapper = BeanUtil.getMapper(name);
            String prefix = mappingPrefix;
            if (StringUtil.isNotNull(prefix)) {
                if (!prefix.endsWith("_")) {
                    prefix = prefix + "_";
                }
                mapper = prefix + mapper;
            }
            parsed.setTableName(mapper);
            parsed.setOriginTable(mapper);
        }
        BeanElement one = null;
        Iterator<BeanElement> ite = elementList.iterator();
        while (ite.hasNext()) {
            BeanElement be = ite.next();
            if (!be.getProperty().equals(parsed.getKey(1))) continue;
            one = be;
            ite.remove();
        }
        elementList.add(0, one);
        Iterator<BeanElement> beIte = parsed.getBeanElementList().iterator();
        while (beIte.hasNext()) {
            if (null != beIte.next()) continue;
            beIte.remove();
        }
        BeanUtilX.parseCacheableAnno(clz, parsed);
        Parser.put(clz, parsed);
    }

    public static ReflectionCache getReflectionCache(Class clz) {
        ReflectionCache cache = cacheMap.get(clz);
        if (cache == null) {
            cache = new ReflectionCache();
            cache.setClz(clz);
            cache.cache();
            cacheMap.put(clz, cache);
        }
        return cache;
    }
}

