/*
 * Decompiled with CFR 0.152.
 */
package io.xream.x7.common.bean;

import io.xream.x7.common.bean.BeanElement;
import io.xream.x7.common.bean.ConjunctionAndOtherScript;
import io.xream.x7.common.bean.CriteriaCondition;
import io.xream.x7.common.bean.KeyMapper;
import io.xream.x7.common.bean.MinMax;
import io.xream.x7.common.bean.Parsed;
import io.xream.x7.common.bean.Parser;
import io.xream.x7.common.bean.PredicateAndOtherScript;
import io.xream.x7.common.bean.X;
import io.xream.x7.common.filter.BaseTypeFilter;
import io.xream.x7.common.support.TimestampSupport;
import io.xream.x7.common.util.BeanUtil;
import io.xream.x7.common.util.StringUtil;
import java.util.Iterator;
import java.util.List;

public interface ConditionCriteriaToSql
extends KeyMapper {
    default public void buildConditionSql(StringBuilder sb, List<X> listX) {
        if (listX == null || listX.isEmpty()) {
            return;
        }
        for (X x : listX) {
            if (x.getPredicate() == PredicateAndOtherScript.SUB) {
                if (x.getSubList().isEmpty()) continue;
                x.getSubList().get(0).setConjunction(ConjunctionAndOtherScript.NONE);
                sb.append(x.getConjunction().sql());
                sb.append(" ").append("(").append(" ");
                this.buildConditionSql(sb, x.getSubList());
                sb.append(" ").append(")");
                continue;
            }
            sb.append(x.getConjunction().sql()).append(x.getKey()).append(x.getPredicate().sql());
            if (x.getValue() == null) continue;
            if (x.getPredicate() == PredicateAndOtherScript.IN || x.getPredicate() == PredicateAndOtherScript.NOT_IN) {
                List inList = (List)x.getValue();
                Object v = inList.get(0);
                Class<?> vType = v.getClass();
                ConditionCriteriaToSql.buildIn(sb, vType, inList);
                continue;
            }
            if (x.getPredicate() == PredicateAndOtherScript.IS_NULL || x.getPredicate() == PredicateAndOtherScript.IS_NOT_NULL || x.getPredicate() == PredicateAndOtherScript.X) continue;
            sb.append("?").append(" ");
        }
    }

    public static void buildIn(StringBuilder sb, Class clz, List<? extends Object> inList) {
        sb.append("(").append(" ");
        int length = inList.size();
        if (clz == String.class) {
            for (int j = 0; j < length; ++j) {
                Object value = inList.get(j);
                if (value == null || StringUtil.isNullOrEmpty(value.toString())) continue;
                value = ConditionCriteriaToSql.filter(value.toString());
                sb.append("'").append(value).append("'");
                if (j >= length - 1) continue;
                sb.append(",");
            }
        } else if (BeanUtil.isEnum(clz)) {
            for (int j = 0; j < length; ++j) {
                Object value = inList.get(j);
                if (value == null) continue;
                String ev = null;
                ev = value instanceof String ? (String)value : ((Enum)value).name();
                sb.append("'").append(ev).append("'");
                if (j >= length - 1) continue;
                sb.append(",");
            }
        } else {
            for (int j = 0; j < length; ++j) {
                Object value = inList.get(j);
                if (value == null) continue;
                sb.append(value);
                if (j >= length - 1) continue;
                sb.append(",");
            }
        }
        sb.append(" ").append(")");
    }

    public static String filter(String sql) {
        sql = sql.replace("drop", " ").replace(";", " ");
        return sql;
    }

    public static interface Pre {
        default public void pre(List<Object> valueList, List<X> listX) {
            for (X x : listX) {
                if (x.getPredicate() == PredicateAndOtherScript.SUB) {
                    this.pre(valueList, x.getSubList());
                    continue;
                }
                if (x.getPredicate() == PredicateAndOtherScript.IN || x.getPredicate() == PredicateAndOtherScript.NOT_IN || x.getPredicate() == PredicateAndOtherScript.IS_NULL || x.getPredicate() == PredicateAndOtherScript.IS_NOT_NULL) continue;
                if (x.getPredicate() == PredicateAndOtherScript.X) {
                    Object value = x.getValue();
                    if (value == null || !(value instanceof Object[])) continue;
                    for (Object v : (Object[])value) {
                        Pre.add(valueList, v);
                    }
                    continue;
                }
                if (x.getPredicate() == PredicateAndOtherScript.BETWEEN) {
                    MinMax minMax = (MinMax)x.getValue();
                    valueList.add(minMax.getMin());
                    valueList.add(minMax.getMax());
                    continue;
                }
                Object v = x.getValue();
                Pre.add(valueList, v);
            }
        }

        public static void add(List<Object> valueList, Object value) {
            if (BeanUtil.isEnum(value.getClass())) {
                try {
                    valueList.add(((Enum)value).name());
                }
                catch (Exception exception) {}
            } else {
                valueList.add(value);
            }
        }
    }

    public static interface Filter {
        default public void filter(List<X> xList, CriteriaCondition criteria) {
            if (xList == null || xList.isEmpty()) {
                return;
            }
            Iterator<X> ite = xList.iterator();
            while (ite.hasNext()) {
                List<X> subList;
                X x = ite.next();
                PredicateAndOtherScript p = x.getPredicate();
                String key = x.getKey();
                if (p == PredicateAndOtherScript.SUB) {
                    this.filter(x.getSubList(), criteria);
                    if (x.getSubList().isEmpty()) {
                        ite.remove();
                    }
                } else if (p == PredicateAndOtherScript.EQ || p == PredicateAndOtherScript.NE || p == PredicateAndOtherScript.GT || p == PredicateAndOtherScript.GTE || p == PredicateAndOtherScript.LT || p == PredicateAndOtherScript.LTE) {
                    if (key.contains(".")) {
                        String[] arr = key.split("\\.");
                        String alia = arr[0];
                        String clzName = criteria.getAliaMap().get(alia);
                        if (clzName == null) {
                            clzName = alia;
                        }
                        Parsed parsed = Parser.get(clzName);
                        if (BaseTypeFilter.isBaseType_0(arr[1], x.getValue(), parsed)) {
                            ite.remove();
                        } else {
                            BeanElement be = parsed.getElement(arr[1]);
                            if (be == null) {
                                throw new RuntimeException("property of " + parsed.getClz() + " not exists: " + arr[1]);
                            }
                            TimestampSupport.testNumberValueToDate(be.clz, x);
                            if (x.getValue() == null) {
                                ite.remove();
                            }
                        }
                    } else {
                        Parsed parsed = criteria.getParsed();
                        if (BaseTypeFilter.isBaseType_0(key, x.getValue(), parsed)) {
                            ite.remove();
                        } else {
                            BeanElement be = parsed.getElement(key);
                            if (be == null) {
                                throw new RuntimeException("property of " + parsed.getClz() + " not exists: " + key);
                            }
                            TimestampSupport.testNumberValueToDate(be.clz, x);
                            if (x.getValue() == null) {
                                ite.remove();
                            }
                        }
                    }
                } else if (p == PredicateAndOtherScript.IN || p == PredicateAndOtherScript.NOT_IN) {
                    List valueList = (List)x.getValue();
                    if (valueList.size() > 1) continue;
                    if (key.contains(".")) {
                        if (BaseTypeFilter.isBaseType_0(key, valueList.get(0), criteria)) {
                            ite.remove();
                        }
                    } else {
                        Parsed parsed = criteria.getParsed();
                        if (BaseTypeFilter.isBaseType_0(key, valueList.get(0), parsed)) {
                            ite.remove();
                        }
                    }
                }
                if ((subList = x.getSubList()) == null || subList.isEmpty()) continue;
                this.filter(subList, criteria);
            }
        }
    }
}

