/*
 * Decompiled with CFR 0.152.
 */
package io.xream.x7.common.bean;

import io.xream.x7.common.bean.PredicateAndOtherScript;
import io.xream.x7.common.bean.X;
import io.xream.x7.common.util.BeanUtilX;
import io.xream.x7.common.util.StringUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class ConditionCriteriaBuilder {
    private ConditionCriteriaBuilder instance;
    private transient List<X> listX;
    private transient boolean isOr;
    private transient List<X> tempList;
    private transient List<List<X>> subsList = new LinkedList<List<X>>();

    protected ConditionCriteriaBuilder() {
        this.instance = this;
    }

    protected ConditionCriteriaBuilder(List<X> listX) {
        this.instance = this;
        this.instance.listX = listX;
    }

    protected void init(List<X> listX) {
        this.listX = listX;
    }

    public static ConditionCriteriaBuilder build(List<X> listX) {
        return new ConditionCriteriaBuilder(listX);
    }

    public ConditionCriteriaBuilder eq(String property, Object value) {
        return this.doGle(PredicateAndOtherScript.EQ, property, value);
    }

    public ConditionCriteriaBuilder lt(String property, Object value) {
        return this.doGle(PredicateAndOtherScript.LT, property, value);
    }

    public ConditionCriteriaBuilder lte(String property, Object value) {
        return this.doGle(PredicateAndOtherScript.LTE, property, value);
    }

    public ConditionCriteriaBuilder gt(String property, Object value) {
        return this.doGle(PredicateAndOtherScript.GT, property, value);
    }

    public ConditionCriteriaBuilder gte(String property, Object value) {
        return this.doGle(PredicateAndOtherScript.GTE, property, value);
    }

    public ConditionCriteriaBuilder ne(String property, Object value) {
        return this.doGle(PredicateAndOtherScript.NE, property, value);
    }

    public ConditionCriteriaBuilder like(String property, String value) {
        if (StringUtil.isNullOrEmpty(value)) {
            this.isOr();
            return this.instance;
        }
        String likeValue = "%" + value + "%";
        return this.doLike(PredicateAndOtherScript.LIKE, property, likeValue);
    }

    public ConditionCriteriaBuilder likeRight(String property, String value) {
        if (StringUtil.isNullOrEmpty(value)) {
            this.isOr();
            return this.instance;
        }
        String likeValue = value + "%";
        return this.doLike(PredicateAndOtherScript.LIKE, property, likeValue);
    }

    public ConditionCriteriaBuilder notLike(String property, String value) {
        if (StringUtil.isNullOrEmpty(value)) {
            this.isOr();
            return this.instance;
        }
        String likeValue = "%" + value + "%";
        return this.doLike(PredicateAndOtherScript.NOT_LIKE, property, likeValue);
    }

    public ConditionCriteriaBuilder in(String property, List<? extends Object> list) {
        return this.doIn(PredicateAndOtherScript.IN, property, list);
    }

    public ConditionCriteriaBuilder nin(String property, List<? extends Object> list) {
        return this.doIn(PredicateAndOtherScript.NOT_IN, property, list);
    }

    public ConditionCriteriaBuilder nonNull(String property) {
        return this.doNull(PredicateAndOtherScript.IS_NOT_NULL, property);
    }

    public ConditionCriteriaBuilder isNull(String property) {
        return this.doNull(PredicateAndOtherScript.IS_NULL, property);
    }

    public ConditionCriteriaBuilder x(String sql, Object ... values) {
        if (StringUtil.isNullOrEmpty(sql)) {
            this.isOr();
            return this.instance;
        }
        sql = BeanUtilX.normalizeSql(sql);
        X x = new X(this.isOr());
        x.setPredicate(PredicateAndOtherScript.X);
        x.setKey(sql);
        x.setValue(values);
        this.add(x);
        return this.instance;
    }

    @Deprecated
    public ConditionCriteriaBuilder and() {
        this.isOr = false;
        return this.instance;
    }

    public ConditionCriteriaBuilder or() {
        this.isOr = true;
        return this.instance;
    }

    public ConditionCriteriaBuilder beginSub() {
        X x = new X(this.isOr());
        x.setPredicate(PredicateAndOtherScript.SUB);
        ArrayList<X> subList = new ArrayList<X>();
        x.setSubList(subList);
        this.add(x);
        this.tempList = subList;
        this.subsList.add(subList);
        return this.instance;
    }

    public ConditionCriteriaBuilder endSub() {
        this.isOr();
        int size = this.subsList.size();
        if (--size >= 0) {
            this.subsList.remove(size);
        }
        this.tempList = --size >= 0 ? this.subsList.get(size) : null;
        return this.instance;
    }

    private ConditionCriteriaBuilder doGle(PredicateAndOtherScript p, String property, Object value) {
        if (value == null) {
            this.isOr();
            return this.instance;
        }
        if (StringUtil.isNullOrEmpty(value)) {
            this.isOr();
            return this.instance;
        }
        X x = new X(this.isOr());
        x.setPredicate(p);
        x.setKey(property);
        x.setValue(value);
        this.add(x);
        return this.instance;
    }

    private ConditionCriteriaBuilder doLike(PredicateAndOtherScript p, String property, String likeWalue) {
        X x = new X(this.isOr());
        x.setPredicate(p);
        x.setKey(property);
        x.setValue(likeWalue);
        this.add(x);
        return this.instance;
    }

    private ConditionCriteriaBuilder doIn(PredicateAndOtherScript p, String property, List<? extends Object> list) {
        if (list == null || list.isEmpty()) {
            this.isOr();
            return this.instance;
        }
        ArrayList<Object> tempList = new ArrayList<Object>();
        for (Object object : list) {
            if (Objects.isNull(object) || tempList.contains(object)) continue;
            tempList.add(object);
        }
        if (tempList.isEmpty()) {
            this.isOr();
            return this.instance;
        }
        X x = new X(this.isOr());
        x.setPredicate(p);
        x.setKey(property);
        x.setValue(tempList);
        this.add(x);
        return this.instance;
    }

    private ConditionCriteriaBuilder doNull(PredicateAndOtherScript p, String property) {
        if (StringUtil.isNullOrEmpty(property)) {
            this.isOr();
            return this.instance;
        }
        X x = new X(this.isOr());
        x.setPredicate(p);
        x.setKey(property);
        x.setValue(p);
        this.add(x);
        return this.instance;
    }

    private boolean isOr() {
        if (this.isOr) {
            this.isOr = false;
            return true;
        }
        return false;
    }

    private void add(X x) {
        if (this.tempList == null) {
            this.listX.add(x);
        } else {
            this.tempList.add(x);
        }
    }
}

