/*
 * Decompiled with CFR 0.152.
 */
package io.xream.x7.common.web;

import com.alibaba.fastjson.JSONObject;
import io.xream.x7.common.bean.Sort;
import io.xream.x7.common.util.JsonX;
import io.xream.x7.common.web.Paged;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Page<T>
implements Paged,
Serializable {
    private static final long serialVersionUID = -3917421382413274341L;
    private Class<T> clz;
    private int rows = 20;
    private int page = 1;
    private long totalRows = -1L;
    private List<T> list = new ArrayList<T>();
    private List<String> keyList = new ArrayList<String>();
    private boolean isScroll;
    private List<Sort> sortList;

    public Page() {
    }

    public Page(Paged paged) {
        this.setScroll(paged.isScroll());
        if (paged.getPage() > 0) {
            this.setPage(paged.getPage());
        }
        if (paged.getRows() > 0) {
            this.setRows(paged.getRows());
        }
        this.setSortList(paged.getSortList());
    }

    public Class<T> getClz() {
        return this.clz;
    }

    public void setClz(Class clz) {
        this.clz = clz;
        if (Objects.nonNull(this.list) && this.list.size() > 0) {
            ArrayList<T> tempList = new ArrayList<T>();
            tempList.addAll(this.list);
            this.list.clear();
            this.setList(tempList);
        }
    }

    @Override
    public int getRows() {
        if (this.rows == 0) {
            return 20;
        }
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public long getTotalRows() {
        return this.totalRows;
    }

    public void setTotalRows(long totalRows) {
        this.totalRows = totalRows;
    }

    public List<T> getList() {
        return this.list;
    }

    public void reSetList(List<T> list) {
        this.list = list;
    }

    @Deprecated
    public void setList(List<T> list) {
        if (Objects.isNull(this.clz)) {
            this.list = list;
            return;
        }
        if (Objects.nonNull(this.list) && !this.list.isEmpty()) {
            this.list = list;
            return;
        }
        if (Objects.isNull(this.list)) {
            this.list = new ArrayList<T>();
        }
        for (T t : list) {
            if (this.clz == Map.class) {
                this.list.add(t);
                continue;
            }
            if (t instanceof JSONObject) {
                T obj = JsonX.toObject(t, this.clz);
                this.list.add(obj);
                continue;
            }
            this.list.add(t);
        }
    }

    public List<String> getKeyList() {
        return this.keyList;
    }

    public void setKeyList(List<String> keyList) {
        this.keyList = keyList;
    }

    @Override
    public boolean isScroll() {
        return this.isScroll;
    }

    public void setScroll(boolean isScroll) {
        this.isScroll = isScroll;
    }

    @Override
    public List<Sort> getSortList() {
        return this.sortList;
    }

    public void setSortList(List<Sort> sortList) {
        this.sortList = sortList;
    }

    public int getTotalPages() {
        int totalPages = (int)(this.totalRows / (long)this.getRows());
        if (this.totalRows % (long)this.getRows() > 0L) {
            ++totalPages;
        }
        return totalPages;
    }

    @Override
    public int getPage() {
        if (this.isScroll) {
            return this.page;
        }
        if (this.totalRows == -1L) {
            return this.page;
        }
        if (this.totalRows == 0L) {
            return 1;
        }
        int maxPage = (int)(this.totalRows / (long)this.getRows());
        if (this.totalRows % (long)this.getRows() > 0L) {
            ++maxPage;
        }
        if (this.page > maxPage) {
            this.page = maxPage;
        }
        if (this.page < 1) {
            return 1;
        }
        return this.page;
    }

    public String toString() {
        return "Page [isScroll=" + this.isScroll + ", totalRows=" + this.totalRows + ", page=" + this.page + ", rows=" + this.rows + ", sortList=" + this.sortList + ", \n\t\tlist=" + this.list + ", \n\t\tkeyList=" + this.keyList;
    }
}

