/*
 * Decompiled with CFR 0.152.
 */
package io.xream.x7.common.async;

import io.xream.x7.common.async.HeartBeat;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class HeartBeator {
    private static final long INTERVAL = 50L;
    private static final TimeUnit UNIT = TimeUnit.MILLISECONDS;
    private static final ScheduledExecutorService service = Executors.newScheduledThreadPool(1);
    private static final CopyOnWriteArrayList<HeartBeat> tasks = new CopyOnWriteArrayList();
    private static HeartBeator instance;

    public static void newInstance() {
        if (instance == null) {
            instance = new HeartBeator();
        }
    }

    private HeartBeator() {
    }

    private static void schedule(Runnable command, long scheduledAt, long delay) {
        long now = System.currentTimeMillis();
        if (scheduledAt <= now) {
            scheduledAt += 86400000L;
        }
        service.scheduleWithFixedDelay(command, scheduledAt - now, delay, UNIT);
    }

    private static void tick() {
        long now = System.currentTimeMillis();
        for (HeartBeat task : tasks) {
            try {
                task.tick(now);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void add(HeartBeat task) {
        tasks.add(task);
    }

    public static void remove(HeartBeat task) {
        tasks.remove(task);
    }

    static {
        HeartBeator.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    HeartBeator.tick();
                }
                catch (NullPointerException npe) {
                    npe.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, System.currentTimeMillis() + 1000L, 50L);
    }
}

