/*
 * Decompiled with CFR 0.152.
 */
package io.xream.x7.common.util;

import io.xream.x7.common.util.StringUtil;
import java.math.BigDecimal;
import java.util.regex.Pattern;

public class NumberUtil {
    private static final int DEF_DIV_SCALE = 10;

    public static double getValue(Double d) {
        return d == null ? 0.0 : d;
    }

    public static int getValue(Integer i) {
        return i == null ? 0 : i;
    }

    public static float getValue(Float f) {
        return f == null ? 0.0f : f.floatValue();
    }

    public static long getValue(Long l) {
        return l == null ? 0L : l;
    }

    public static double getMoney(double d) {
        double result = NumberUtil.getValue(d) * 100.0;
        result = Math.round(result);
        int i = (int)result;
        return (double)i / 100.0;
    }

    public static double getWeight(double w) {
        double result = NumberUtil.getValue(w) * 1000.0;
        result = Math.round(result);
        int i = (int)result;
        return (double)i / 1000.0;
    }

    public static double add(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.add(b2).doubleValue();
    }

    public static double sub(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.subtract(b2).doubleValue();
    }

    public static double mul(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.multiply(b2).doubleValue();
    }

    public static double div(double v1, double v2) {
        return NumberUtil.div(v1, v2, 10);
    }

    public static double div(double v1, double v2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.divide(b2, scale, 4).doubleValue();
    }

    public static double round(double v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b = new BigDecimal(Double.toString(v));
        BigDecimal one = new BigDecimal("1");
        return b.divide(one, scale, 4).doubleValue();
    }

    public static boolean isNumeric(String str) {
        if (StringUtil.isNullOrEmpty(str)) {
            return false;
        }
        Pattern pattern = null;
        pattern = str.contains(".") ? Pattern.compile("-?[0-9]+.?[0-9]+") : Pattern.compile("-?[0-9]+");
        return pattern.matcher(str).matches();
    }
}

