/*
 * Decompiled with CFR 0.152.
 */
package io.xream.x7.common.util;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    private StringUtil() {
    }

    public static String toUTF8(String strISO88591) {
        try {
            return new String(strISO88591.getBytes("ISO8859-1"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return strISO88591;
        }
    }

    public static boolean isNotNull(String str) {
        return !StringUtil.isNullOrEmpty(str);
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.equals("") || str.equals("null") || str.equals("NaN") || str.equals("undefined");
    }

    public static boolean isNullOrEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        Class<?> clz = obj.getClass();
        if (clz == String.class) {
            return StringUtil.isNullOrEmpty(obj.toString());
        }
        return false;
    }

    public static boolean isMobile(String mobile) {
        String pMobile = "^(1(([34578][0-9])))\\d{8}$";
        return Pattern.matches(pMobile, mobile);
    }

    public static boolean isNumeric(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmail(String email) {
        if (email.indexOf("@") == -1) {
            return false;
        }
        String pEmail = "^[\\w-]{1,40}(\\.[\\w-]{1,20}){0,6}@[\\w-]{1,40}(\\.[\\w-]{1,20}){1,6}$";
        return Pattern.matches(pEmail, email);
    }

    public static String nullToEmpty(String str) {
        if (StringUtil.isNullOrEmpty(str)) {
            return "";
        }
        return str;
    }

    public static List<String> listByRegEx(String str, Pattern pattern) {
        Matcher matcher = pattern.matcher(str);
        ArrayList<String> list = new ArrayList<String>();
        while (matcher.find()) {
            CharSequence subSequence = str.subSequence(matcher.start(0), matcher.end(0));
            list.add(subSequence.toString());
        }
        return list;
    }
}

