/*
 * Decompiled with CFR 0.152.
 */
package io.xream.x7.exception;

import io.xream.x7.common.util.ExceptionUtil;
import io.xream.x7.exception.PersistenceException;
import io.xream.x7.exception.QueryException;
import org.slf4j.Logger;

public class ExceptionTranslator {
    private ExceptionTranslator() {
    }

    public static PersistenceException onRollback(Object obj, Exception e, Logger logger) {
        Throwable t = ExceptionUtil.unwrapThrowable(e);
        String msg = ExceptionUtil.getMessage(t);
        String objStr = obj == null ? "" : obj.toString();
        String logStr = objStr + ", Exception: " + msg;
        String eStr = objStr + ", \nException: " + msg;
        logger.error(logStr);
        return new PersistenceException(eStr);
    }

    public static QueryException onQuery(Exception e, Logger logger) {
        Throwable t = ExceptionUtil.unwrapThrowable(e);
        String msg = ExceptionUtil.getMessage(t);
        logger.error(msg);
        return new QueryException(msg);
    }
}

