/*
 * Decompiled with CFR 0.152.
 */
package io.xream.x7.common.util;

import io.xream.x7.common.bean.BeanElement;
import io.xream.x7.common.bean.Criteria;
import io.xream.x7.common.bean.CriteriaCondition;
import io.xream.x7.common.bean.Parsed;
import io.xream.x7.common.bean.SqlScript;
import io.xream.x7.common.repository.X;
import io.xream.x7.common.util.BeanUtil;
import io.xream.x7.common.util.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BeanUtilX
extends BeanUtil {
    public static final String SQL_KEYWORD_MARK = "`";
    private static Set<String> opSet = new HashSet(){
        {
            this.add("=");
            this.add("!");
            this.add(">");
            this.add("<");
            this.add("+");
            this.add("-");
            this.add("*");
            this.add("/");
            this.add("(");
            this.add(")");
            this.add(";");
        }
    };

    private BeanUtilX() {
    }

    public static List<BeanElement> getElementList(Class clz) {
        BeanElement be;
        ArrayList<Field> fl = new ArrayList<Field>();
        if (clz.getSuperclass() != Object.class) {
            fl.addAll(Arrays.asList(clz.getSuperclass().getDeclaredFields()));
        }
        fl.addAll(Arrays.asList(clz.getDeclaredFields()));
        HashMap<String, Field> filterMap = new HashMap<String, Field>();
        HashMap<String, Field> allMap = new HashMap<String, Field>();
        for (Field f : fl) {
            Object p;
            allMap.put(f.getName(), f);
            if (f.getModifiers() >= 128) {
                filterMap.put(f.getName(), f);
            }
            if ((p = f.getAnnotation(X.Ignore.class)) == null) continue;
            filterMap.put(f.getName(), f);
        }
        HashSet<String> mns = new HashSet<String>();
        ArrayList<Method> ml = new ArrayList<Method>();
        if (clz.getSuperclass() != Object.class) {
            ml.addAll(Arrays.asList(clz.getSuperclass().getDeclaredMethods()));
        }
        ml.addAll(Arrays.asList(clz.getDeclaredMethods()));
        for (Method method : ml) {
            mns.add(method.getName());
        }
        ArrayList<BeanElement> filterList = new ArrayList<BeanElement>();
        for (Method m : ml) {
            String name = m.getName();
            if (!name.startsWith("set") && !name.startsWith("get") && !name.startsWith("is")) continue;
            String key = BeanUtilX.getProperty(name);
            be = null;
            for (BeanElement b : filterList) {
                if (!b.getProperty().equals(key)) continue;
                be = b;
                break;
            }
            if (be == null) {
                be = new BeanElement();
                be.setProperty(key);
                filterList.add(be);
            }
            if (name.startsWith("set")) {
                be.setter = name;
                continue;
            }
            if (name.startsWith("get")) {
                be.getter = name;
                be.clz = m.getReturnType();
                continue;
            }
            if (!name.startsWith("is")) continue;
            be.getter = name;
            be.clz = m.getReturnType();
            be.setProperty(name);
            String setter = BeanUtilX.getSetter(name);
            if (!mns.contains(setter)) continue;
            be.setter = setter;
        }
        Iterator iterator = filterList.iterator();
        while (iterator.hasNext()) {
            BeanElement be2 = (BeanElement)iterator.next();
            if (be2.isPair()) continue;
            iterator.remove();
        }
        block13: for (Iterator key : filterMap.keySet()) {
            Iterator beIte = filterList.iterator();
            while (beIte.hasNext()) {
                be = (BeanElement)beIte.next();
                if (!be.getProperty().equals(key)) continue;
                beIte.remove();
                continue block13;
            }
        }
        ArrayList<BeanElement> list = new ArrayList<BeanElement>();
        for (BeanElement element : filterList) {
            BeanUtilX.parseAnno(clz, element, (Field)allMap.get(element.getProperty()));
            Class ec = element.clz;
            if (element.sqlType == null) {
                if (ec == Integer.TYPE || ec == Integer.class) {
                    element.sqlType = "int";
                    element.length = 11;
                } else if (ec == Long.TYPE || ec == Long.class) {
                    element.sqlType = "bigint";
                    element.length = 13;
                } else if (ec == Double.TYPE || ec == Double.class) {
                    element.sqlType = "float";
                    element.length = 13;
                } else if (ec == Float.TYPE || ec == Float.class) {
                    element.sqlType = "float";
                    element.length = 13;
                } else if (ec == Boolean.TYPE || ec == Boolean.class) {
                    element.sqlType = "tinyint";
                    element.length = 1;
                } else if (ec == java.util.Date.class || ec == Date.class || ec == Timestamp.class) {
                    element.sqlType = "timestamp";
                } else if (ec == String.class) {
                    element.sqlType = "varchar";
                    if (element.length == 0) {
                        element.length = 60;
                    }
                } else if (ec == BigDecimal.class) {
                    element.sqlType = "decimal";
                } else if (BeanUtil.isEnum(ec)) {
                    element.sqlType = "varchar";
                    if (element.length == 0) {
                        element.length = 40;
                    }
                } else {
                    element.isJson = true;
                    if (ec == List.class) {
                        Class geneType;
                        Field field = null;
                        try {
                            field = clz.getDeclaredField(element.getProperty());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        ParameterizedType pt = (ParameterizedType)field.getGenericType();
                        element.geneType = geneType = (Class)pt.getActualTypeArguments()[0];
                    }
                    element.sqlType = "varchar";
                    if (element.length == 0) {
                        element.length = 512;
                    }
                }
            } else if (element.sqlType.contains("text")) {
                element.length = 0;
            } else {
                element.sqlType = "varchar";
            }
            list.add(element);
        }
        try {
            for (BeanElement be3 : list) {
                try {
                    be3.setMethod = clz.getDeclaredMethod(be3.setter, be3.clz);
                }
                catch (NoSuchMethodException e) {
                    be3.setMethod = clz.getSuperclass().getDeclaredMethod(be3.setter, be3.clz);
                }
                try {
                    be3.getMethod = clz.getDeclaredMethod(be3.getter, new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    be3.getMethod = clz.getSuperclass().getDeclaredMethod(be3.getter, new Class[0]);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static void parseCacheableAnno(Class clz, Parsed parsed) {
        X.NoCache p = clz.getAnnotation(X.NoCache.class);
        if (p != null) {
            parsed.setNoCache(true);
        }
    }

    public static void parseAnno(Class clz, BeanElement ele, Field f) {
        X p;
        Method m = null;
        try {
            m = clz.getDeclaredMethod(ele.getter, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (m != null && (p = m.getAnnotation(X.class)) != null) {
            ele.sqlType = p.type();
            ele.length = p.length();
        }
        if (f != null) {
            X.Mapping mapping;
            p = f.getAnnotation(X.class);
            if (p != null) {
                ele.sqlType = p.type();
                ele.length = p.length();
            }
            if ((mapping = f.getAnnotation(X.Mapping.class)) != null && StringUtil.isNotNull(mapping.value())) {
                ele.mapper = mapping.value();
            }
        }
    }

    public static void parseKey(Parsed parsed, Class clz) {
        Map<Integer, String> map = parsed.getKeyMap();
        Map<Integer, Field> keyFieldMap = parsed.getKeyFieldMap();
        ArrayList<Field> list = new ArrayList<Field>();
        try {
            list.addAll(Arrays.asList(clz.getDeclaredFields()));
            Class sc = clz.getSuperclass();
            if (sc != Object.class) {
                list.addAll(Arrays.asList(sc.getDeclaredFields()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Field f : list) {
            X.Key a = f.getAnnotation(X.Key.class);
            if (a == null) continue;
            map.put(1, f.getName());
            f.setAccessible(true);
            keyFieldMap.put(1, f);
        }
    }

    public static <T> void sort(Class<T> clz, List<T> list, String property, boolean isAsc) {
        list.sort((a, b) -> BeanUtilX.compare(clz, property, isAsc, a, b));
    }

    private static <T> int compare(Class clz, String orderBy, boolean isAsc, T a, T b) {
        try {
            int scValue = isAsc ? 1 : -1;
            Field field = clz.getDeclaredField(orderBy);
            field.setAccessible(true);
            Object valueA = field.get(a);
            Object valueB = field.get(b);
            if (field.getType() == String.class) {
                char intB;
                char intA = valueA.toString().charAt(0);
                if (intA > (intB = valueB.toString().charAt(0))) {
                    return 1 * scValue;
                }
                if (intA < intB) {
                    return -1 * scValue;
                }
                return 0;
            }
            BigDecimal bdA = new BigDecimal(valueA.toString().toCharArray());
            BigDecimal bdB = new BigDecimal(valueB.toString().toCharArray());
            return bdA.compareTo(bdB) * scValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static void sort(List<Map<String, Object>> list, String property, boolean isAsc) {
        list.sort((a, b) -> BeanUtilX.compare(property, isAsc, a, b));
    }

    private static int compare(String property, boolean isAsc, Map<String, Object> a, Map<String, Object> b) {
        int scValue = isAsc ? 1 : -1;
        Object valueA = a.get(property);
        Object valueB = b.get(property);
        if (valueA instanceof String) {
            char intB;
            char intA = valueA.toString().charAt(0);
            if (intA > (intB = valueB.toString().charAt(0))) {
                return 1 * scValue;
            }
            if (intA < intB) {
                return -1 * scValue;
            }
            return 0;
        }
        BigDecimal bdA = new BigDecimal(valueA.toString().toCharArray());
        BigDecimal bdB = new BigDecimal(valueB.toString().toCharArray());
        return bdA.compareTo(bdB) * scValue;
    }

    public static String filterSQLKeyword(String mapper) {
        for (String keyWord : SqlScript.KEYWORDS) {
            if (!keyWord.equals(mapper.toLowerCase())) continue;
            return SQL_KEYWORD_MARK + mapper + SQL_KEYWORD_MARK;
        }
        return mapper;
    }

    public static String normalizeSql(String manuSql) {
        StringBuilder valueSb = new StringBuilder();
        boolean ignore = false;
        int length = manuSql.length();
        for (int j = 0; j < length; ++j) {
            String strEle = String.valueOf(manuSql.charAt(j));
            if (" ".equals(strEle)) {
                ignore = true;
                continue;
            }
            if (opSet.contains(strEle)) {
                String nextOp;
                valueSb.append(" ");
                valueSb.append(strEle);
                if (j + 1 < length && opSet.contains(nextOp = String.valueOf(manuSql.charAt(j + 1)))) {
                    valueSb.append(nextOp);
                    ++j;
                }
                valueSb.append(" ");
            } else {
                if (ignore) {
                    valueSb.append(" ");
                }
                valueSb.append(strEle);
            }
            ignore = false;
        }
        return valueSb.toString();
    }

    public static String getClzName(String alia, CriteriaCondition criteria) {
        String a;
        if (criteria.getAliaMap() != null && StringUtil.isNotNull(a = criteria.getAliaMap().get(alia))) {
            return a;
        }
        return alia;
    }

    public static void aliaToClzzForMapResult(Criteria.ResultMappedCriteria resultMapped, List<Map<String, Object>> mapList) {
        Map<String, String> aliaMap = resultMapped.getAliaMap();
        for (Map.Entry<String, String> entry : aliaMap.entrySet()) {
            if (!entry.getKey().equals(entry.getValue())) continue;
            return;
        }
        for (Map map : mapList) {
            HashMap clzKeyMap = new HashMap();
            for (Map.Entry entry : map.entrySet()) {
                String alia = (String)entry.getKey();
                Object obj = entry.getValue();
                String clzName = aliaMap.get(alia);
                clzKeyMap.put(clzName, obj);
            }
            map.clear();
            map.putAll(clzKeyMap);
        }
    }

    public static <T> Object tryToGetId(T t, Parsed parsed) {
        Field f = parsed.getKeyField(1);
        Object id = null;
        try {
            id = f.get(t);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (id == null) {
            throw new IllegalArgumentException("obj keyOne = " + id + ", " + t);
        }
        return id;
    }

    public static String getCacheKey(Object obj, Parsed parsed) {
        try {
            Object keyOneObj = BeanUtilX.tryToGetId(obj, parsed);
            if (keyOneObj != null) {
                return keyOneObj.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

