/*
 * Decompiled with CFR 0.152.
 */
package io.xream.x7.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BeanMapUtil {
    private BeanMapUtil() {
    }

    public static <T> T toObject(Class<T> clz, Map<String, Object> map) {
        if (clz == Map.class) {
            return (T)map;
        }
        ArrayList<Field> fl = new ArrayList<Field>();
        if (clz.getSuperclass() != Object.class) {
            fl.addAll(Arrays.asList(clz.getSuperclass().getDeclaredFields()));
        }
        fl.addAll(Arrays.asList(clz.getDeclaredFields()));
        T obj = null;
        try {
            obj = clz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e1) {
            e1.printStackTrace();
        }
        try {
            for (Field f : fl) {
                Number vL;
                int modifiers = f.getModifiers();
                String key = f.getName();
                if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) continue;
                f.setAccessible(true);
                Object v = map.get(key);
                if (v == null) continue;
                String name = f.getType().getName().toLowerCase();
                Class<?> fc = f.getType();
                if (name.contains("double")) {
                    try {
                        f.set(obj, v);
                    }
                    catch (Exception e) {
                        f.set(obj, Double.valueOf(v.toString()));
                    }
                    continue;
                }
                if (name.contains("long") || name.contains("Long")) {
                    if (v instanceof String) {
                        vL = Long.valueOf((String)v);
                        long vl = (Long)vL;
                        f.set(obj, vl);
                        continue;
                    }
                    f.set(obj, v);
                    continue;
                }
                if (name.contains("int")) {
                    if (v instanceof String) {
                        vL = Integer.valueOf((String)v);
                        int vl = (Integer)vL;
                        f.set(obj, vl);
                        continue;
                    }
                    f.set(obj, v);
                    continue;
                }
                if (v instanceof Map) {
                    f.set(obj, BeanMapUtil.toObject(fc, (Map)v));
                    continue;
                }
                if (v instanceof Long && f.getType() == Date.class) {
                    f.set(obj, new Date((Long)v));
                    continue;
                }
                f.set(obj, v);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }

    public static Map<String, String> toStringMap(Object obj) {
        ArrayList<Field> fl = new ArrayList<Field>();
        Class<?> clz = obj.getClass();
        if (clz.getSuperclass() != Object.class) {
            fl.addAll(Arrays.asList(clz.getSuperclass().getDeclaredFields()));
        }
        fl.addAll(Arrays.asList(clz.getDeclaredFields()));
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            for (Field f : fl) {
                int modifiers = f.getModifiers();
                String key = f.getName();
                if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) continue;
                f.setAccessible(true);
                Object value = f.get(obj);
                if (value == null) {
                    map.put(key, null);
                    continue;
                }
                map.put(key, value.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static Map<String, Object> toObjectMap(Object obj) {
        ArrayList<Field> fl = new ArrayList<Field>();
        Class<?> clz = obj.getClass();
        if (clz.getSuperclass() != Object.class) {
            fl.addAll(Arrays.asList(clz.getSuperclass().getDeclaredFields()));
        }
        fl.addAll(Arrays.asList(clz.getDeclaredFields()));
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            for (Field f : fl) {
                int modifiers = f.getModifiers();
                String key = f.getName();
                if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) continue;
                f.setAccessible(true);
                Object value = f.get(obj);
                map.put(key, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static Map<String, Object> toJsonableMap(Map<String, Object> stringKeyMap) {
        HashMap<String, Object> jsonableMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> es : stringKeyMap.entrySet()) {
            String stringKey = es.getKey();
            if (stringKey.contains(".")) {
                stringKey = stringKey.replace(".", "->");
                String[] arr = stringKey.split("->");
                String jsonKey = arr[0];
                String propKey = arr[1];
                Object obj = jsonableMap.get(jsonKey);
                HashMap<String, Object> objMap = null;
                if (Objects.isNull(obj)) {
                    objMap = new HashMap<String, Object>();
                    jsonableMap.put(jsonKey, objMap);
                } else {
                    objMap = (HashMap<String, Object>)obj;
                }
                objMap.put(propKey, es.getValue());
                continue;
            }
            jsonableMap.put(stringKey, es.getValue());
        }
        return jsonableMap;
    }

    public static List<Map<String, Object>> toJsonableMapList(List<Map<String, Object>> stringKeyList) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> map : stringKeyList) {
            Map<String, Object> jsonKeyMap = BeanMapUtil.toJsonableMap(map);
            list.add(jsonKeyMap);
        }
        return list;
    }

    public static List<String> toStringKeyList(Map<String, Object> jonsableMap) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : jonsableMap.entrySet()) {
            String key = entry.getKey();
            Object obj = entry.getValue();
            if (Objects.isNull(obj)) continue;
            Map map = (Map)obj;
            for (Map.Entry es : map.entrySet()) {
                String str = key + "." + (String)es.getKey();
                list.add(str);
            }
        }
        return list;
    }
}

