/*
 * Decompiled with CFR 0.152.
 */
package io.xream.x7.common.bean;

import io.xream.x7.common.bean.ConditionCriteriaBuilder;
import io.xream.x7.common.bean.Criteria;
import io.xream.x7.common.bean.Distinct;
import io.xream.x7.common.bean.FunctionResultKey;
import io.xream.x7.common.bean.Having;
import io.xream.x7.common.bean.JoinFrom;
import io.xream.x7.common.bean.JoinType;
import io.xream.x7.common.bean.KV;
import io.xream.x7.common.bean.On;
import io.xream.x7.common.bean.Op;
import io.xream.x7.common.bean.PageBuilder;
import io.xream.x7.common.bean.Parsed;
import io.xream.x7.common.bean.Parser;
import io.xream.x7.common.bean.Reduce;
import io.xream.x7.common.bean.ReduceType;
import io.xream.x7.common.bean.ResultKeyAlia;
import io.xream.x7.common.bean.Sort;
import io.xream.x7.common.bean.SourceScript;
import io.xream.x7.common.bean.SourceScriptBuilder;
import io.xream.x7.common.util.BeanMapUtil;
import io.xream.x7.common.util.StringUtil;
import io.xream.x7.common.web.Direction;
import io.xream.x7.common.web.Fetched;
import io.xream.x7.common.web.MapResult;
import io.xream.x7.common.web.Paged;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.util.Assert;

public class CriteriaBuilder
extends ConditionCriteriaBuilder {
    private Criteria criteria;
    private PageBuilder pageBuilder = new PageBuilder(){

        @Override
        public PageBuilder ignoreTotalRows() {
            CriteriaBuilder.this.criteria.setTotalRowsIgnored(true);
            return this;
        }

        @Override
        public PageBuilder rows(int rows) {
            CriteriaBuilder.this.criteria.setRows(rows);
            return this;
        }

        @Override
        public PageBuilder page(int page) {
            CriteriaBuilder.this.criteria.setPage(page);
            return this;
        }

        @Override
        public PageBuilder orderIn(String porperty, List<? extends Object> inList) {
            if (Objects.nonNull(inList) && inList.size() > 0) {
                KV kv = new KV(porperty, inList);
                CriteriaBuilder.this.criteria.getFixedSortList().add(kv);
            }
            return this;
        }

        @Override
        public PageBuilder sort(String orderBy, Direction direction) {
            if (StringUtil.isNullOrEmpty(orderBy)) {
                return this;
            }
            List<Sort> sortList = CriteriaBuilder.this.criteria.getSortList();
            if (sortList == null) {
                sortList = new ArrayList<Sort>();
                CriteriaBuilder.this.criteria.setSortList(sortList);
            }
            Sort sort = new Sort(orderBy, direction);
            sortList.add(sort);
            return this;
        }
    };
    protected SourceScript sourceScriptTemp;

    public CriteriaBuilder routeKey(Object routeKey) {
        this.criteria.setRouteKey(routeKey);
        return this;
    }

    public PageBuilder paged() {
        return this.pageBuilder;
    }

    public void paged(Paged paged) {
        this.criteria.paged(paged);
    }

    public CriteriaBuilder forceIndex(String indexName) {
        if (StringUtil.isNullOrEmpty(indexName)) {
            return this;
        }
        this.criteria.setForceIndex(indexName);
        return this;
    }

    private CriteriaBuilder(Criteria criteria) {
        super(criteria.getListX());
        this.criteria = criteria;
    }

    public static CriteriaBuilder build(Class<?> clz) {
        Criteria criteria = new Criteria();
        criteria.setClz(clz);
        CriteriaBuilder builder = new CriteriaBuilder(criteria);
        if (criteria.getParsed() == null) {
            Parsed parsed = Parser.get(clz);
            criteria.setParsed(parsed);
        }
        return builder;
    }

    public static CriteriaBuilder build(Class<?> clz, Paged paged) {
        Criteria criteria = new Criteria();
        criteria.setClz(clz);
        CriteriaBuilder builder = new CriteriaBuilder(criteria);
        if (criteria.getParsed() == null) {
            Parsed parsed = Parser.get(clz);
            criteria.setParsed(parsed);
        }
        if (paged != null) {
            builder.paged(paged);
        }
        return builder;
    }

    @Deprecated
    public static ResultMappedBuilder buildResultMapped(Fetched ro) {
        Criteria.ResultMappedCriteria resultMappedCriteria = new Criteria.ResultMappedCriteria();
        ResultMappedBuilder builder = new ResultMappedBuilder(resultMappedCriteria);
        if (ro != null) {
            builder.xAddResultKey(ro);
            if (ro instanceof Paged) {
                builder.paged((Paged)((Object)ro));
            }
        }
        return builder;
    }

    public static ResultMappedBuilder buildResultMapped(MapResult ro) {
        Criteria.ResultMappedCriteria resultMappedCriteria = new Criteria.ResultMappedCriteria();
        ResultMappedBuilder builder = new ResultMappedBuilder(resultMappedCriteria);
        if (ro != null) {
            builder.xAddResultKey(ro);
            if (ro instanceof Paged) {
                builder.paged((Paged)((Object)ro));
            }
        }
        return builder;
    }

    public static ResultMappedBuilder buildResultMapped() {
        Criteria.ResultMappedCriteria resultMappedCriteria = new Criteria.ResultMappedCriteria();
        return new ResultMappedBuilder(resultMappedCriteria);
    }

    public Class<?> getClz() {
        return this.criteria.getClz();
    }

    public Criteria get() {
        return this.criteria;
    }

    public static class ResultMappedBuilder
    extends CriteriaBuilder {
        private SourceScriptBuilder sourceScriptBuilder = new SourceScriptBuilder(){

            @Override
            public SourceScriptBuilder source(String source) {
                sourceScriptTemp.setSource(source);
                return this;
            }

            @Override
            public SourceScriptBuilder alia(String alia) {
                sourceScriptTemp.setAlia(alia);
                return this;
            }

            @Override
            public SourceScriptBuilder joinType(JoinType joinType) {
                sourceScriptTemp.setJoinType(joinType);
                return this;
            }

            @Override
            public SourceScriptBuilder on(String key, JoinFrom joinFrom) {
                if (key.contains(".")) {
                    throw new IllegalArgumentException("On key can not contains '.'");
                }
                On on = new On();
                on.setKey(key);
                on.setOp(Op.EQ.sql());
                on.setJoinFrom(joinFrom);
                sourceScriptTemp.setOn(on);
                return this;
            }

            @Override
            public SourceScriptBuilder on(String key, Op op, JoinFrom joinFrom) {
                if (key.contains(".")) {
                    throw new IllegalArgumentException("On key can not contains '.'");
                }
                On on = new On();
                on.setKey(key);
                on.setOp(op.sql());
                on.setJoinFrom(joinFrom);
                sourceScriptTemp.setOn(on);
                return this;
            }

            @Override
            public ConditionCriteriaBuilder more() {
                return ConditionCriteriaBuilder.build(sourceScriptTemp.getListX());
            }
        };

        public SourceScriptBuilder sourceScript() {
            this.sourceScriptTemp = new SourceScript();
            this.get().getSourceScripts().add(this.sourceScriptTemp);
            return this.sourceScriptBuilder;
        }

        public ResultMappedBuilder withoutOptimization() {
            this.get().setWithoutOptimization(true);
            return this;
        }

        @Override
        public Criteria.ResultMappedCriteria get() {
            return (Criteria.ResultMappedCriteria)super.get();
        }

        private void init() {
            Criteria.ResultMappedCriteria resultMapped = new Criteria.ResultMappedCriteria();
            ((CriteriaBuilder)this).criteria = resultMapped;
        }

        private void init(Class<?> clz) {
            Criteria.ResultMappedCriteria f = (Criteria.ResultMappedCriteria)((CriteriaBuilder)this).criteria;
            f.setClz(clz);
            Parsed parsed = Parser.get(clz);
            f.setParsed(parsed);
        }

        public ResultMappedBuilder(Criteria criteria) {
            super(criteria);
        }

        private void xAddResultKey(List<String> xExpressionList) {
            for (String xExpression : xExpressionList) {
                this.get().getResultKeyList().add(xExpression);
            }
        }

        private void xAddResultKey(Fetched fetchResult) {
            if (fetchResult == null) {
                return;
            }
            Map<String, Object> resultObjMap = fetchResult.getResultKeyMap();
            if (resultObjMap == null || resultObjMap.isEmpty()) {
                return;
            }
            List<String> xExpressionList = BeanMapUtil.toStringKeyList(resultObjMap);
            this.xAddResultKey(xExpressionList);
        }

        private void xAddResultKey(MapResult mappedKey) {
            if (mappedKey == null) {
                return;
            }
            String[] arr = mappedKey.getResultKeys();
            if (arr == null || arr.length == 0) {
                return;
            }
            List<String> list = Arrays.asList(arr);
            this.xAddResultKey(list);
        }

        public ResultMappedBuilder resultKey(String resultKey) {
            if (StringUtil.isNullOrEmpty(resultKey)) {
                return this;
            }
            this.get().getResultKeyList().add(resultKey);
            return this;
        }

        public ResultMappedBuilder resultKey(String resultKey, String alia) {
            if (StringUtil.isNullOrEmpty(resultKey)) {
                return this;
            }
            Assert.notNull((Object)alia, (String)"resultKeyAssignedAlia(), alia can not null");
            this.get().getResultKeyAssignedAliaList().add(new KV(resultKey, alia));
            return this;
        }

        public ResultMappedBuilder resultWithDottedKey() {
            this.get().setResultWithDottedKey(true);
            return this;
        }

        public ResultMappedBuilder resultKeyFunction(ResultKeyAlia functionAlia_wrap, String functionScript, String ... keys) {
            if (StringUtil.isNullOrEmpty(functionScript) || keys == null) {
                return this;
            }
            Assert.notNull((Object)functionAlia_wrap, (String)"function no alia");
            Assert.notNull((Object)functionAlia_wrap.getPropertyOrAlia());
            FunctionResultKey functionResultKey = new FunctionResultKey();
            functionResultKey.setScript(functionScript);
            functionResultKey.setAlia(functionAlia_wrap.getAlia());
            functionResultKey.setKeys(keys);
            this.get().getResultFuntionList().add(functionResultKey);
            return this;
        }

        @Override
        public void paged(Paged paged) {
            ((CriteriaBuilder)this).criteria.paged(paged);
        }

        public ResultMappedBuilder sourceScript(String sourceScript) {
            if (StringUtil.isNullOrEmpty(sourceScript)) {
                return this;
            }
            this.get().setSourceScript(sourceScript);
            return this;
        }

        public ResultMappedBuilder distinct(Object ... objs) {
            if (objs == null) {
                throw new RuntimeException("distinct non resultKey");
            }
            Criteria.ResultMappedCriteria resultMapped = this.get();
            Distinct distinct = resultMapped.getDistinct();
            if (Objects.isNull(distinct)) {
                distinct = new Distinct();
                resultMapped.setDistinct(distinct);
            }
            for (Object obj : objs) {
                if (obj instanceof String) {
                    distinct.add(obj.toString());
                    continue;
                }
                if (obj instanceof Map) {
                    Map map = (Map)obj;
                    Set set = map.entrySet();
                    for (Map.Entry entry : set) {
                        Object key = entry.getKey();
                        Object value = entry.getValue();
                        if (!(value instanceof Map)) continue;
                        Map vMap = (Map)value;
                        for (Object k : vMap.keySet()) {
                            distinct.add(key.toString() + "." + k.toString());
                        }
                    }
                    continue;
                }
                throw new RuntimeException("distinct param suggests String, or Map");
            }
            return this;
        }

        public ResultMappedBuilder groupBy(String property) {
            this.get().setGroupBy(property);
            return this;
        }

        public ResultMappedBuilder reduce(ReduceType type, String property) {
            Reduce reduce = new Reduce();
            reduce.setType(type);
            reduce.setProperty(property);
            this.get().getReduceList().add(reduce);
            return this;
        }

        public ResultMappedBuilder reduce(ReduceType type, String property, Having having) {
            Reduce reduce = new Reduce();
            reduce.setType(type);
            reduce.setProperty(property);
            reduce.setHaving(having);
            this.get().getReduceList().add(reduce);
            return this;
        }
    }
}

