/*
 * Decompiled with CFR 0.152.
 */
package io.xream.x7.common.web;

import io.xream.x7.common.util.JsonX;
import io.xream.x7.common.web.ViewStatus;

public interface RestAPI {
    public static final String TOAST_SIGN_EXCEPTION = "SIGN UNAVAILABLE";

    public static class Message<T> {
        private ViewStatus status;
        private T body;
        private String id;
        private long time;
        private String sign;

        public ViewStatus getStatus() {
            return this.status;
        }

        public void setStatus(ViewStatus status) {
            this.status = status;
        }

        public T getBody() {
            return this.body;
        }

        public void setBody(T body) {
            this.body = body;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public long getTime() {
            return this.time;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public String getSign() {
            return this.sign;
        }

        public void setSign(String sign) {
            this.sign = sign;
        }

        public String toString() {
            return "Message [status=" + (Object)((Object)this.status) + ", body=" + this.body + ", id=" + this.id + ", time=" + this.time + ", sign=" + this.sign + "]";
        }
    }

    public static class SendMessage {
        public static Message toast(String str) {
            Message<String> message = new Message<String>();
            message.setStatus(ViewStatus.FAIL);
            message.setBody(str);
            return message;
        }

        public static Message ok(Object obj, Signed signed) {
            Message<Object> message = new Message<Object>();
            message.setStatus(ViewStatus.OK);
            message.setBody(obj);
            message.setId(signed.getId());
            message.setTime(signed.getTime());
            message.setSign(signed.sign());
            return message;
        }
    }

    public static class Callback {
        public static Message parse(String responseStr, Signed signed) {
            Message result = JsonX.toObject(responseStr, Message.class);
            if (result.getStatus().equals((Object)ViewStatus.FAIL)) {
                return result;
            }
            if (!result.getSign().equals(signed.sign())) {
                throw new SignException(RestAPI.TOAST_SIGN_EXCEPTION);
            }
            return result;
        }
    }

    public static class RequestMessage<T> {
        private T body;
        private String id;
        private long time;
        private String sign;

        public boolean isSigned(Signed signed) {
            return this.sign.equals(signed.sign());
        }

        public T getBody() {
            return this.body;
        }

        public void setBody(T body) {
            this.body = body;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public long getTime() {
            return this.time;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public String getSign() {
            return this.sign;
        }

        public void setSign(String sign) {
            this.sign = sign;
        }

        public String toString() {
            return "RequestMessage [body=" + this.body + ", id=" + this.id + ", time=" + this.time + ", sign=" + this.sign + "]";
        }
    }

    public static class SignException
    extends RuntimeException {
        private String message;

        public SignException(String message) {
            this.message = message;
        }

        public SignException() {
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    public static interface Signed {
        public String sign();

        public long getTime();

        public String getId();
    }
}

