/*
 * Decompiled with CFR 0.152.
 */
package io.xream.x7.common.util;

import java.util.Random;

public class MathExt {
    private static final Random random = new Random();

    public static int moveLeft(int i, int offset) {
        return i << offset;
    }

    public static int random(int i) {
        return random.nextInt(i);
    }

    public static int random(int min, int i) {
        return min + random.nextInt(i - min);
    }

    public static int randomByWeights(int[] weights) {
        int length = weights.length;
        int totalWeight = 0;
        for (int i = 0; i < length; ++i) {
            totalWeight += weights[i];
        }
        if (totalWeight == 0) {
            return -1;
        }
        int hit = MathExt.random(totalWeight);
        totalWeight = 0;
        for (int i = 0; i < length; ++i) {
            if ((totalWeight += weights[i]) < hit) continue;
            return i;
        }
        return 0;
    }

    public static boolean isHitByRate(int rate) {
        if (rate < 1) {
            return false;
        }
        if (rate >= 100) {
            return true;
        }
        return (double)rate >= Math.random() * 100.0 + 1.0;
    }

    public static boolean isHitByRate(double rate) {
        if (rate <= 0.0) {
            return false;
        }
        if (rate > 1.0) {
            return true;
        }
        return rate >= Math.random();
    }

    public static int LH(int low, int high, int i) {
        if (i < low) {
            return low;
        }
        if (i > high) {
            return high;
        }
        return i;
    }

    public static double LH(double low, double high, double i) {
        if (i < low) {
            return low;
        }
        if (i > high) {
            return high;
        }
        return i;
    }

    public static int sumReplace(int oldValue, int newValue, int replacedTimes) {
        return (newValue - oldValue) * replacedTimes;
    }

    public static int fixLevel(int level, int[] levelSections) {
        if (levelSections == null) {
            return -1;
        }
        int length = levelSections.length;
        for (int i = length - 1; i >= 0; --i) {
            if (level < levelSections[i]) continue;
            return levelSections[i];
        }
        return -1;
    }

    public static int dividePlusOneOnFactor(double n, double dv, double factor) {
        double t = n / dv;
        int r = (int)t;
        if (t - (double)r >= factor) {
            return r + 1;
        }
        return r;
    }
}

