/*
 * Decompiled with CFR 0.152.
 */
package io.xream.x7.common.util;

import io.xream.x7.common.bean.FieldAndMethod;
import io.xream.x7.common.bean.Parser;
import io.xream.x7.common.repository.ReflectionCache;
import io.xream.x7.common.util.StringUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;

public class BeanUtil {
    public static String getSetter(Class<?> type, String property) {
        if (type != Boolean.class && property.startsWith("is")) {
            String rest = property.substring(2);
            return "set" + rest;
        }
        String a = property.substring(0, 1);
        String rest = property.substring(1);
        return "set" + a.toUpperCase() + rest;
    }

    public static String getGetter(Class<?> type, String property) {
        if (type != Boolean.class && property.startsWith("is")) {
            return property;
        }
        String a = property.substring(0, 1);
        String rest = property.substring(1);
        return "get" + a.toUpperCase() + rest;
    }

    public static String getGetter(String property) {
        if (property.startsWith("is")) {
            return property;
        }
        String a = property.substring(0, 1);
        String rest = property.substring(1);
        return "get" + a.toUpperCase() + rest;
    }

    public static String getSetter(String property) {
        if (property.startsWith("is")) {
            String rest = property.substring(2);
            return "set" + rest;
        }
        String a = property.substring(0, 1);
        String rest = property.substring(1);
        return "set" + a.toUpperCase() + rest;
    }

    public static String getByFirstLower(String str) {
        if (StringUtil.isNullOrEmpty(str)) {
            return str;
        }
        String a = str.substring(0, 1);
        String rest = str.substring(1);
        String result = a.toLowerCase() + rest;
        return result;
    }

    public static String getByFirstUpper(String str) {
        if (StringUtil.isNullOrEmpty(str)) {
            return str;
        }
        String a = str.substring(0, 1);
        String rest = str.substring(1);
        String result = a.toUpperCase() + rest;
        return result;
    }

    public static String getProperty(String methodName) {
        if (methodName.startsWith("is")) {
            return methodName;
        }
        methodName = methodName.substring(3);
        return BeanUtil.getByFirstLower(methodName);
    }

    public static String getPropertyOfBoolen(String setter) {
        return "is" + setter.substring(3);
    }

    public static <T> T copy(Class<T> clz, Object origin) {
        if (origin == null) {
            return null;
        }
        T t = null;
        String p = "";
        Object v = null;
        try {
            t = clz.newInstance();
            Class<?> oc = origin.getClass();
            ReflectionCache originCache = Parser.getReflectionCache(oc);
            ReflectionCache cache = Parser.getReflectionCache(clz);
            for (FieldAndMethod fnm : cache.getMap().values()) {
                FieldAndMethod originFnm = originCache.get(fnm.getProperty());
                if (originFnm == null && (originFnm = originCache.getTemp(fnm.getProperty())) == null) {
                    originFnm = new FieldAndMethod();
                    originCache.getTempMap().put(fnm.getProperty(), originFnm);
                    String getterName = fnm.getGetterName();
                    Method orginGetter = null;
                    try {
                        orginGetter = oc.getDeclaredMethod(getterName, new Class[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (orginGetter != null) {
                        originFnm.setGetter(orginGetter);
                        originFnm.setGetterName(getterName);
                        String setterName = fnm.getSetterName();
                        Method orginSetter = null;
                        try {
                            orginSetter = oc.getDeclaredMethod(setterName, fnm.getField().getType());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (orginSetter != null) {
                            originFnm.setSetter(orginSetter);
                            originFnm.setSetterName(setterName);
                        }
                        originFnm.setProperty(fnm.getProperty());
                    }
                }
                try {
                    if (originFnm == null || originFnm.getGetterName() == null) continue;
                    v = oc.getDeclaredMethod(originFnm.getGetterName(), new Class[0]).invoke(origin, new Object[0]);
                    Method m = fnm.getSetter();
                    m.invoke(t, v);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            System.out.println("p = " + p + ", v = " + v);
            e.printStackTrace();
        }
        return t;
    }

    public static void copy(Object target, Object origin) {
        if (origin == null || target == null) {
            return;
        }
        try {
            Class<?> clz = target.getClass();
            Class<?> oc = origin.getClass();
            Method[] originMethodArr = oc.getDeclaredMethods();
            HashSet<String> methodSet = new HashSet<String>();
            for (Method m : originMethodArr) {
                methodSet.add(m.getName());
            }
            for (Method m : clz.getDeclaredMethods()) {
                if (!m.getName().startsWith("set")) continue;
                String p = "";
                p = m.getParameterTypes()[0] == Boolean.TYPE || m.getParameterTypes()[0] == Boolean.class ? BeanUtil.getPropertyOfBoolen(m.getName()) : BeanUtil.getProperty(m.getName());
                String getter = BeanUtil.getGetter(p);
                if (!methodSet.contains(getter)) continue;
                Object v = null;
                try {
                    v = oc.getDeclaredMethod(getter, new Class[0]).invoke(origin, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (v == null) continue;
                m.invoke(target, v);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void copyX(Object target, Object origin) {
        if (origin == null || target == null) {
            return;
        }
        Class<?> clz = target.getClass();
        Class<?> oc = origin.getClass();
        ReflectionCache cache = Parser.getReflectionCache(clz);
        HashSet<String> set = new HashSet<String>();
        for (Method m : oc.getDeclaredMethods()) {
            set.add(m.getName());
        }
        for (FieldAndMethod fam : cache.getMap().values()) {
            if (!set.contains(fam.getGetterName())) continue;
            Object v = null;
            try {
                Method om = oc.getDeclaredMethod(fam.getGetterName(), new Class[0]);
                v = om.invoke(origin, new Object[0]);
                Class<?> rt = om.getReturnType();
                if ((rt == Integer.TYPE || rt == Long.TYPE || rt == Double.TYPE || rt == Float.TYPE || rt == Boolean.TYPE) && v.toString().equals("0")) {
                    v = null;
                }
            }
            catch (Exception om) {
                // empty catch block
            }
            if (v == null) continue;
            try {
                fam.getSetter().invoke(target, v);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String getMapper(String property) {
        String AZ = "AZ";
        int min = AZ.charAt(0) - '\u0001';
        int max = AZ.charAt(1) + '\u0001';
        try {
            String spec = Parser.mappingSpec;
            if (StringUtil.isNotNull(spec)) {
                String s;
                char[] arr = property.toCharArray();
                int length = arr.length;
                ArrayList<String> list = new ArrayList<String>();
                StringBuilder temp = new StringBuilder();
                for (int i = 0; i < length; ++i) {
                    char c = arr[i];
                    if (c > min && c < max) {
                        String ts = temp.toString();
                        if (StringUtil.isNotNull(ts)) {
                            list.add(temp.toString());
                        }
                        temp = new StringBuilder();
                        s = String.valueOf(c);
                        temp.append(s.toLowerCase());
                    } else {
                        temp = temp.append(c);
                    }
                    if (i != length - 1) continue;
                    list.add(temp.toString());
                }
                String str = "";
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    s = (String)list.get(i);
                    str = str + s;
                    if (i >= size - 1) continue;
                    str = str + "_";
                }
                return str;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return property;
    }
}

