/*
 * Decompiled with CFR 0.152.
 */
package io.xream.x7.common.event;

import io.xream.x7.common.event.Event;
import io.xream.x7.common.event.EventListener;
import io.xream.x7.common.event.EventReceiver;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class EventDispatcher
implements EventReceiver {
    private static List<Event> eventList = new ArrayList<Event>();
    private static boolean eventListenerEnabled = false;

    public static List<Event> getEventTemplateList() {
        return eventList;
    }

    protected static void enableEventListener() {
        eventListenerEnabled = true;
    }

    public static boolean isEventListenerEnabled() {
        return eventListenerEnabled;
    }

    protected static void addEventTemplate(Event event) {
        eventList.add(event);
    }

    public static void addEventListener(String eventType, EventListener.Handler listener) {
        String key;
        TreeMap<String, EventListener.Handler> listenerMap = (TreeMap<String, EventListener.Handler>)listenersMap.get(eventType);
        if (listenerMap == null) {
            listenerMap = new TreeMap<String, EventListener.Handler>();
            listenersMap.put(eventType, listenerMap);
        }
        if (!listenerMap.containsKey(key = EventDispatcher.createKey(listener))) {
            listenerMap.put(key, listener);
        }
    }

    public static void removeEventListener(String eventType, EventListener.Handler listener) {
        TreeMap listenerMap = (TreeMap)listenersMap.get(eventType);
        if (listenerMap != null) {
            listenerMap.remove(EventDispatcher.createKey(listener));
            if (listenerMap.size() == 0) {
                listenersMap.remove(eventType);
            }
        }
    }

    public static void dispatch(Event event) {
        String key = event.getType() + event.getTag();
        TreeMap listenerMap = (TreeMap)listenersMap.get(key);
        if (listenerMap == null) {
            return;
        }
        for (EventListener.Handler listener : listenerMap.values()) {
            if (listener == null) continue;
            try {
                listener.handle(event);
            }
            catch (Exception e) {
                System.out.println("\nException, while handling event: " + event + "\n");
                e.printStackTrace();
            }
        }
    }

    private static String createKey(EventListener.Handler listener) {
        if (listener.getClass().getName().contains("EventListener.Handler")) {
            return listener.getClass().getName() + listener.hashCode();
        }
        return listener.getClass().getName();
    }
}

