/*
 * Decompiled with CFR 0.152.
 */
package io.xream.x7.common.bean;

import io.xream.x7.common.bean.BeanElement;
import io.xream.x7.common.bean.Criteria;
import io.xream.x7.common.bean.Parsed;
import io.xream.x7.common.bean.Transformed;
import io.xream.x7.common.bean.condition.InCondition;
import io.xream.x7.common.repository.ReflectionCache;
import io.xream.x7.common.repository.X;
import io.xream.x7.common.util.BeanUtil;
import io.xream.x7.common.util.BeanUtilX;
import io.xream.x7.common.util.ExceptionUtil;
import io.xream.x7.common.util.StringUtil;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parser {
    private static Logger logger = LoggerFactory.getLogger(Parser.class);
    private static final Map<Class, Parsed> map = new ConcurrentHashMap<Class, Parsed>();
    private static final Map<String, Parsed> simpleNameMap = new ConcurrentHashMap<String, Parsed>();
    private static final Map<Class, ReflectionCache> cacheMap = new ConcurrentHashMap<Class, ReflectionCache>();
    public static String mappingPrefix;
    public static String mappingSpec;

    public static void put(Class clz, Parsed parsed) {
        map.put(clz, parsed);
        String key = BeanUtil.getByFirstLower(clz.getSimpleName());
        simpleNameMap.put(key, parsed);
    }

    public static Parsed get(Class clz) {
        Parsed parsed = map.get(clz);
        if (parsed == null) {
            Parser.parse(clz);
            parsed = map.get(clz);
            Field f = parsed.getKeyField(1);
            if (f == null) {
                throw new RuntimeException("No Primary Key, class: " + clz.getName());
            }
        }
        return parsed;
    }

    public static Parsed get(String simpleName) {
        return simpleNameMap.get(simpleName);
    }

    public static void parse(Class clz) {
        boolean isNoSpec;
        Parsed parsed;
        List<BeanElement> elementList;
        block16: {
            if (clz == Criteria.class || clz == Criteria.ResultMappedCriteria.class) {
                throw new RuntimeException("parser unsupport Criteria, CriteriaJoinable, ....");
            }
            elementList = BeanUtilX.getElementList(clz);
            parsed = new Parsed(clz);
            for (BeanElement beanElement : elementList) {
                if (!StringUtil.isNullOrEmpty(beanElement.getMapper())) continue;
                beanElement.initMaper();
            }
            isNoSpec = true;
            try {
                if (StringUtil.isNotNull(mappingSpec)) {
                    isNoSpec = false;
                    break block16;
                }
                for (BeanElement element : elementList) {
                    if (element.getProperty().equals(element.getMapper())) continue;
                    isNoSpec = false;
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        parsed.setNoSpec(isNoSpec);
        parsed.reset(elementList);
        BeanUtilX.parseKey(parsed, clz);
        X.Mapping mapping = clz.getAnnotation(X.Mapping.class);
        if (mapping != null) {
            String tableName = mapping.value();
            if (!tableName.equals("")) {
                parsed.setTableName(tableName);
                parsed.setOriginTable(tableName);
                parsed.setNoSpec(false);
            } else {
                String name = BeanUtil.getByFirstLower(clz.getSimpleName());
                String mapper = BeanUtil.getMapper(name);
                String prefix = mappingPrefix;
                if (StringUtil.isNotNull(prefix)) {
                    if (!prefix.endsWith("_")) {
                        prefix = prefix + "_";
                    }
                    mapper = prefix + mapper;
                }
                parsed.setTableName(mapper);
                parsed.setOriginTable(mapper);
            }
        } else {
            String name = BeanUtil.getByFirstLower(clz.getSimpleName());
            String mapper = BeanUtil.getMapper(name);
            String prefix = mappingPrefix;
            if (StringUtil.isNotNull(prefix)) {
                if (!prefix.endsWith("_")) {
                    prefix = prefix + "_";
                }
                mapper = prefix + mapper;
            }
            parsed.setTableName(mapper);
            parsed.setOriginTable(mapper);
        }
        BeanElement one = null;
        Iterator<BeanElement> ite = elementList.iterator();
        while (ite.hasNext()) {
            BeanElement be = ite.next();
            if (!be.getProperty().equals(parsed.getKey(1))) continue;
            one = be;
            ite.remove();
        }
        elementList.add(0, one);
        Iterator<BeanElement> beIte = parsed.getBeanElementList().iterator();
        while (beIte.hasNext()) {
            if (null != beIte.next()) continue;
            beIte.remove();
        }
        BeanUtilX.parseCacheableAnno(clz, parsed);
        Parser.put(clz, parsed);
        BeanUtilX.parseSearch(parsed, clz);
    }

    public static ReflectionCache getReflectionCache(Class clz) {
        ReflectionCache cache = cacheMap.get(clz);
        if (cache == null) {
            cache = new ReflectionCache();
            cache.setClz(clz);
            cache.cache();
            cacheMap.put(clz, cache);
        }
        return cache;
    }

    public static Parsed getByTableName(String tableName) {
        for (Parsed parsed : map.values()) {
            if (!parsed.getOriginTable().equals(tableName)) continue;
            return parsed;
        }
        return null;
    }

    public static <T> T toLogic(Transformed transformed, Class<T> clz) {
        if (transformed == null) {
            return null;
        }
        T t = null;
        try {
            t = clz.newInstance();
            Parsed parsed = Parser.get(clz);
            Parsed parsedTransformed = Parser.get(transformed.getClass());
            List<BeanElement> logicBeanElementList = parsed.getBeanElementList();
            List<BeanElement> transformedBeanElementList = parsedTransformed.getBeanElementList();
            for (BeanElement logicBe : logicBeanElementList) {
                String logicMapper = logicBe.getMapper();
                for (BeanElement transformedBe : transformedBeanElementList) {
                    Object propertyValue;
                    String transformedMapper = transformedBe.getMapper();
                    if (!logicMapper.equals(transformedMapper) || (propertyValue = transformedBe.getMethod.invoke((Object)transformed, new Object[0])) == null) continue;
                    logicBe.setMethod.invoke(t, propertyValue);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(ExceptionUtil.getMessage(e));
        }
        return t;
    }

    public static <T> Transformed transform(T logic) {
        Class<?> clz = logic.getClass();
        Parsed parsed = Parser.get(clz);
        Parsed parsedTransformed = parsed.getParsedTransformed();
        if (parsedTransformed == null) {
            throw new RuntimeException("SchemaTransform enabled, but can't find config for logic table to target");
        }
        Transformed transformed = null;
        try {
            Class clazz = parsedTransformed.getClz();
            transformed = (Transformed)clazz.newInstance();
            transformed.setAlia(parsed.getTransformedAlia());
            List<BeanElement> logicBeanElementList = parsed.getBeanElementList();
            List<BeanElement> transformedBeanElementList = parsedTransformed.getBeanElementList();
            for (BeanElement logicBe : logicBeanElementList) {
                String logicMapper = logicBe.getMapper();
                for (BeanElement transformedBe : transformedBeanElementList) {
                    Object propertyValue;
                    String transformedMapper = transformedBe.getMapper();
                    if (!logicMapper.equals(transformedMapper) || (propertyValue = logicBe.getMethod.invoke(logic, new Object[0])) == null) continue;
                    transformedBe.setMethod.invoke((Object)transformed, propertyValue);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(ExceptionUtil.getMessage(e));
        }
        return transformed;
    }

    public static <T> Transformed transformForRemove(T logic) {
        Class<?> clz = logic.getClass();
        Parsed parsed = Parser.get(clz);
        Parsed parsedTransformed = parsed.getParsedTransformed();
        if (parsedTransformed == null) {
            throw new RuntimeException("SchemaTransform enabled, but can't find config for logic table to target");
        }
        Transformed transformed = null;
        try {
            Class clazz = parsedTransformed.getClz();
            transformed = (Transformed)clazz.newInstance();
            Field logicKeyField = parsed.getKeyField(1);
            Object keyOne = logicKeyField.get(logic);
            Field transformedKeyField = parsedTransformed.getKeyField(1);
            transformedKeyField.set(transformed, keyOne);
        }
        catch (Exception e) {
            throw new RuntimeException(ExceptionUtil.getMessage(e));
        }
        return transformed;
    }

    public static <T> Class<? extends Transformed> transformClzz(Class<T> clz) {
        Parsed parsed = Parser.get(clz);
        Parsed parsedTransformed = parsed.getParsedTransformed();
        return parsedTransformed.getClz();
    }

    public static InCondition toTransformedInCondition(InCondition inCondition) {
        Class clz = inCondition.getClz();
        Parsed parsed = Parser.get(clz);
        Parsed parsedTransformed = parsed.getParsedTransformed();
        List<BeanElement> transformedBeanElementList = parsedTransformed.getBeanElementList();
        BeanElement logicPropertyBe = parsed.getElement(inCondition.getProperty());
        String mapper = logicPropertyBe.mapper;
        String propertyTransformed = logicPropertyBe.property;
        for (BeanElement transformedBe : transformedBeanElementList) {
            String transformedMapper = transformedBe.getMapper();
            if (!mapper.equals(transformedMapper)) continue;
            propertyTransformed = transformedBe.property;
            break;
        }
        InCondition inConditionTransformed = new InCondition();
        inConditionTransformed.setClz(parsedTransformed.getClz());
        inConditionTransformed.setProperty(propertyTransformed);
        inConditionTransformed.setInList(inCondition.getInList());
        return inConditionTransformed;
    }
}

