/*
 * Decompiled with CFR 0.152.
 */
package io.xream.x7.base.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;

public class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static String getMessage(Exception e) {
        String msg = e.getMessage();
        msg = msg + "\n";
        StackTraceElement[] eleArr = e.getStackTrace();
        if (eleArr == null || eleArr.length == 0) {
            return msg;
        }
        int length = eleArr.length;
        length = length > 6 ? 6 : length;
        for (int i = 0; i < length; ++i) {
            msg = msg + eleArr[i].toString();
            msg = msg + "\n";
        }
        return msg;
    }

    public static String getMessage(Throwable e) {
        String msg = e.getMessage();
        msg = msg + "\n";
        StackTraceElement[] eleArr = e.getStackTrace();
        if (eleArr == null || eleArr.length == 0) {
            return msg;
        }
        int length = eleArr.length;
        length = length > 6 ? 6 : length;
        for (int i = 0; i < length; ++i) {
            msg = msg + eleArr[i].toString();
            msg = msg + "\n";
        }
        return msg;
    }

    public static Throwable unwrapThrowable(Throwable wrapped) {
        Throwable unwrapped = wrapped;
        while (true) {
            if (unwrapped instanceof InvocationTargetException) {
                unwrapped = ((InvocationTargetException)unwrapped).getTargetException();
                continue;
            }
            if (!(unwrapped instanceof UndeclaredThrowableException)) break;
            unwrapped = ((UndeclaredThrowableException)unwrapped).getUndeclaredThrowable();
        }
        return unwrapped;
    }
}

