/*
 * Decompiled with CFR 0.152.
 */
package io.xream.sqli.dialect;

import io.xream.sqli.dialect.Dialect;
import io.xream.sqli.exception.NotSupportedException;
import io.xream.sqli.exception.PersistenceException;
import io.xream.sqli.parser.BeanElement;
import io.xream.sqli.parser.Parsed;
import io.xream.sqli.support.TimeSupport;
import io.xream.sqli.util.EnumUtil;
import io.xream.sqli.util.SqliExceptionUtil;
import io.xream.sqli.util.SqliJsonUtil;
import io.xream.sqli.util.SqliStringUtil;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class OracleDialect
implements Dialect {
    private static final String ORACLE_PAGINATION = "SELECT * FROM (SELECT A.*, ROWNUM RN FROM ( ${SQL} ) A   WHERE ROWNUM <= ${END}  )  WHERE RN > ${BEGIN} ";
    private static final String ORACLE_PAGINATION_REGX_SQL = "${SQL}";
    private static final String ORACLE_PAGINATION_REGX_BEGIN = "${BEGIN}";
    private static final String ORACLE_PAGINATION_REGX_END = "${END}";
    private Method NCLOBReader = null;
    private Method NCLOBLength = null;

    private void init() {
        try {
            Class<?> clzz = Class.forName("oracle.sql.NCLOB");
            this.NCLOBReader = clzz.getDeclaredMethod("getCharacterStream", new Class[0]);
            this.NCLOBLength = clzz.getDeclaredMethod("length", new Class[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public OracleDialect() {
        this.init();
    }

    public String getKey() {
        return "oracle";
    }

    public String buildPageSql(String origin, long start, long rows, long last) {
        if (rows > 0L) {
            return ORACLE_PAGINATION.replace(ORACLE_PAGINATION_REGX_END, String.valueOf(start + rows)).replace(ORACLE_PAGINATION_REGX_BEGIN, String.valueOf(start)).replace(ORACLE_PAGINATION_REGX_SQL, origin);
        }
        return origin;
    }

    private Object toNCLOBString(Object obj) {
        if (obj.getClass().getSimpleName().endsWith("NCLOB")) {
            Reader reader = null;
            try {
                reader = (Reader)this.NCLOBReader.invoke(obj, new Object[0]);
                int length = (Integer)this.NCLOBLength.invoke(obj, new Object[0]);
                char[] charArr = new char[length];
                reader.read(charArr);
                String string = new String(charArr);
                return string;
            }
            catch (Exception e) {
                SqliExceptionUtil.throwRuntimeExceptionFirst((Throwable)e);
                throw new PersistenceException(SqliExceptionUtil.getMessage((Throwable)e));
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return obj;
    }

    private Object toBigDecimal(Class clzz, Object obj) {
        BigDecimal bg = (BigDecimal)obj;
        if (clzz == Integer.TYPE || clzz == Integer.class) {
            return bg.intValue();
        }
        if (clzz == Long.TYPE || clzz == Long.class) {
            return bg.longValue();
        }
        if (clzz == Double.TYPE || clzz == Double.class) {
            return bg.doubleValue();
        }
        if (clzz == Float.TYPE || clzz == Float.class) {
            return Float.valueOf(bg.floatValue());
        }
        if (clzz == Boolean.TYPE || clzz == Boolean.class) {
            int i = bg.intValue();
            return i != 0;
        }
        if (clzz == java.util.Date.class) {
            long l = bg.longValue();
            return new java.util.Date(l);
        }
        if (clzz == Date.class) {
            long l = bg.longValue();
            return new Date(l);
        }
        if (clzz == Timestamp.class) {
            long l = bg.longValue();
            return new Timestamp(l);
        }
        if (clzz == Byte.TYPE || clzz == Byte.class) {
            return bg.byteValue();
        }
        return bg;
    }

    public Object mappingToObject(Object obj, BeanElement element) {
        if (obj == null) {
            return null;
        }
        Class ec = element.getClz();
        obj = this.toNCLOBString(obj);
        if (element.isJson()) {
            if (SqliStringUtil.isNullOrEmpty((Object)obj)) {
                return null;
            }
            String str = obj.toString().trim();
            if (ec == List.class) {
                Class geneType = element.getGeneType();
                return SqliJsonUtil.toList((String)str, (Class)geneType);
            }
            if (ec == Map.class) {
                return SqliJsonUtil.toMap((String)str);
            }
            return SqliJsonUtil.toObject((String)str, (Class)ec);
        }
        if (obj instanceof BigDecimal) {
            return this.toBigDecimal(ec, obj);
        }
        if (obj instanceof Timestamp && ec == java.util.Date.class) {
            Timestamp ts = (Timestamp)obj;
            return new java.util.Date(ts.getTime());
        }
        if (EnumUtil.isEnum((Class)ec)) {
            return EnumUtil.deserialize((Class)ec, (Object)obj.toString());
        }
        return TimeSupport.afterReadTime((Class)ec, (Object)obj);
    }

    public String createOrReplaceSql(String sql) {
        throw new NotSupportedException("sqli not support createOrReplace() for Oracle");
    }

    public String createSql(Parsed parsed, List<BeanElement> tempList) {
        return this.getDefaultCreateSql(parsed, tempList);
    }

    public Object convertJsonToPersist(Object json) {
        if (json == null) {
            return null;
        }
        return new StringReader(json.toString());
    }

    public String transformAlia(String mapper, Map<String, String> aliaMap, Map<String, String> resultKeyAliaMap) {
        if (resultKeyAliaMap.containsKey(mapper)) {
            mapper = resultKeyAliaMap.get(mapper);
        }
        if (aliaMap.isEmpty()) {
            return mapper;
        }
        if (mapper.contains(".")) {
            String[] arr = mapper.split("\\.");
            String alia = arr[0];
            String p = arr[1];
            String clzName = aliaMap.get(alia);
            if (SqliStringUtil.isNullOrEmpty((String)clzName)) {
                clzName = alia;
            }
            return clzName + "." + p;
        }
        return mapper;
    }

    public Object filterValue(Object object) {
        return this.filter(object, obj -> {
            if (obj instanceof java.util.Date) {
                java.util.Date date = (java.util.Date)obj;
                Timestamp timestamp = new Timestamp(date.getTime());
                return timestamp;
            }
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                return b != false ? 1 : 0;
            }
            return obj;
        });
    }

    public Object[] toArr(Collection<Object> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        int size = list.size();
        Object[] arr = new Object[size];
        int i = 0;
        for (Object obj : list) {
            obj = this.filterValue(obj);
            arr[i++] = obj;
        }
        return arr;
    }

    public String getAlterTableUpdate() {
        return "UPDATE";
    }

    public String getAlterTableDelete() {
        return "DELETE FROM";
    }

    public String getCommandUpdate() {
        return "SET";
    }

    public String getCommandDelete() {
        return " ";
    }

    public String getLimitOne() {
        return null;
    }

    public String getInsertTagged() {
        return null;
    }

    public void filterTags(List<BeanElement> list, List<Field> tagList) {
    }

    public List<Object> objectToListForCreate(Object obj, Parsed parsed) {
        List tempList = parsed.getBeanElementList();
        ArrayList<Object> list = new ArrayList<Object>();
        this.objectToListForCreate(list, obj, tempList);
        return list;
    }
}

