/*
 * Decompiled with CFR 0.152.
 */
package io.xream.sqli.dialect;

import io.xream.sqli.dialect.Dialect;
import io.xream.sqli.parser.BeanElement;
import io.xream.sqli.parser.Parsed;
import io.xream.sqli.support.TimeSupport;
import io.xream.sqli.util.EnumUtil;
import io.xream.sqli.util.SqliJsonUtil;
import io.xream.sqli.util.SqliStringUtil;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class MySqlDialect
implements Dialect {
    public String getKey() {
        return "mysql";
    }

    public String buildPageSql(String origin, long start, long rows, long last) {
        if (rows == 0L) {
            return origin;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(origin);
        sb.append(" LIMIT ").append(rows);
        if (last == 0L && start > 0L) {
            sb.append(" OFFSET ").append(start);
        }
        return sb.toString();
    }

    public Object mappingToObject(Object obj, BeanElement element) {
        if (obj == null) {
            return null;
        }
        Class ec = element.getClz();
        if (EnumUtil.isEnum((Class)ec)) {
            return EnumUtil.deserialize((Class)ec, (Object)obj.toString());
        }
        if (element.isJson()) {
            if (SqliStringUtil.isNullOrEmpty((Object)obj)) {
                return null;
            }
            String str = obj.toString().trim();
            if (ec == List.class) {
                Class geneType = element.getGeneType();
                return SqliJsonUtil.toList((String)str, (Class)geneType);
            }
            if (ec == Map.class) {
                return SqliJsonUtil.toMap((String)str);
            }
            return SqliJsonUtil.toObject((String)str, (Class)ec);
        }
        if (ec == BigDecimal.class) {
            return new BigDecimal(String.valueOf(obj));
        }
        if (ec == Double.TYPE || ec == Double.class) {
            return Double.valueOf(obj.toString());
        }
        return TimeSupport.afterReadTime((Class)ec, (Object)obj);
    }

    public String createOrReplaceSql(String sql) {
        return sql.replaceFirst("INSERT", "REPLACE");
    }

    public String createSql(Parsed parsed, List<BeanElement> tempList) {
        return this.getDefaultCreateSql(parsed, tempList);
    }

    public Object convertJsonToPersist(Object json) {
        return json;
    }

    public String transformAlia(String mapper, Map<String, String> aliaMap, Map<String, String> resultKeyAliaMap) {
        if (resultKeyAliaMap.containsKey(mapper)) {
            mapper = resultKeyAliaMap.get(mapper);
        }
        return mapper;
    }

    public Object filterValue(Object object) {
        return this.filter(object, null);
    }

    public Object[] toArr(Collection<Object> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        int size = list.size();
        Object[] arr = new Object[size];
        int i = 0;
        for (Object obj : list) {
            obj = this.filterValue(obj);
            arr[i++] = obj;
        }
        return arr;
    }

    public String getAlterTableUpdate() {
        return "UPDATE";
    }

    public String getAlterTableDelete() {
        return "DELETE FROM";
    }

    public String getCommandUpdate() {
        return "SET";
    }

    public String getCommandDelete() {
        return " ";
    }

    public String getLimitOne() {
        return " LIMIT 1";
    }

    public String getInsertTagged() {
        return null;
    }

    public void filterTags(List<BeanElement> list, List<Field> tagList) {
    }

    public List<Object> objectToListForCreate(Object obj, Parsed parsed) {
        List tempList = parsed.getBeanElementList();
        ArrayList<Object> list = new ArrayList<Object>();
        this.objectToListForCreate(list, obj, tempList);
        return list;
    }
}

