/*
 * Decompiled with CFR 0.152.
 */
package io.xream.sqli.dialect;

import io.xream.sqli.dialect.MySqlDialect;
import io.xream.sqli.exception.ParsingException;
import io.xream.sqli.parser.BeanElement;
import io.xream.sqli.parser.Parsed;
import io.xream.sqli.util.BeanUtil;
import io.xream.sqli.util.EnumUtil;
import io.xream.sqli.util.SqliExceptionUtil;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public final class TAOSDialect
extends MySqlDialect {
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    @Override
    public String getKey() {
        return "taosdata";
    }

    @Override
    public String getInsertTagged() {
        return "? USING #stb# TAGS ";
    }

    @Override
    public void filterTags(List<BeanElement> list, List<Field> tagList) {
        Iterator<BeanElement> ite = list.iterator();
        while (ite.hasNext()) {
            BeanElement be = ite.next();
            for (Field field : tagList) {
                if (!be.getProperty().equals(field.getName())) continue;
                ite.remove();
            }
        }
    }

    @Override
    public Object filterValue(Object value) {
        if (value instanceof Date) {
            return this.sdf.format(value);
        }
        return value;
    }

    @Override
    public Object mappingToObject(Object obj, BeanElement element) {
        if (obj == null) {
            return null;
        }
        Class ec = element.getClz();
        if (ec == Date.class) {
            return new Date((Long)obj);
        }
        if (ec == Timestamp.class) {
            return new Timestamp((Long)obj);
        }
        return super.mappingToObject(obj, element);
    }

    @Override
    public List<Object> objectToListForCreate(Object obj, Parsed parsed) {
        ArrayList<Object> list = new ArrayList<Object>();
        ArrayList<BeanElement> tempList = new ArrayList<BeanElement>();
        tempList.addAll(parsed.getBeanElementList());
        List tagFieldList = parsed.getTagFieldList();
        this.filterTags(tempList, tagFieldList);
        try {
            boolean hasSubKey = parsed.getTagKeyField() != null;
            String dynamicTableName = parsed.getTableName();
            if (hasSubKey) {
                dynamicTableName = dynamicTableName + "_" + parsed.getTagKeyField().get(obj);
                list.add(dynamicTableName);
            }
            for (Field field : tagFieldList) {
                Object value = field.get(obj);
                if (EnumUtil.isEnum(field.getType())) {
                    Object enumObj = EnumUtil.serialize((Enum)((Enum)value));
                    list.add(enumObj);
                } else {
                    list.add(value);
                }
                if (hasSubKey) continue;
                dynamicTableName = dynamicTableName + "_" + value.hashCode();
            }
            if (!hasSubKey) {
                list.add(0, dynamicTableName);
            }
        }
        catch (Exception e) {
            SqliExceptionUtil.throwRuntimeExceptionFirst((Throwable)e);
            throw new ParsingException(SqliExceptionUtil.getMessage((Throwable)e));
        }
        this.objectToListForCreate(list, obj, tempList);
        return list;
    }

    @Override
    public String createSql(Parsed parsed, List<BeanElement> tempList) {
        int i;
        if (parsed.getTagFieldList().isEmpty()) {
            return this.getDefaultCreateSql(parsed, tempList);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ");
        String insertTagged = this.getInsertTagged();
        insertTagged = insertTagged.replace("#stb#", BeanUtil.getByFirstLower((String)parsed.getClzName()));
        int size = parsed.getTagFieldList().size();
        sb.append(insertTagged).append("(");
        for (i = 0; i < size; ++i) {
            sb.append("?");
            if (i >= size - 1) continue;
            sb.append(",");
        }
        this.filterTags(tempList, parsed.getTagFieldList());
        sb.append(") VALUES (");
        size = tempList.size();
        for (i = 0; i < size; ++i) {
            sb.append("?");
            if (i >= size - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }
}

