/*
 * Decompiled with CFR 0.152.
 */
package io.xream.sqli.dialect;

import io.xream.sqli.core.Dialect;
import io.xream.sqli.exception.NotSupportedException;
import io.xream.sqli.exception.PersistenceException;
import io.xream.sqli.parser.BeanElement;
import io.xream.sqli.util.BeanUtil;
import io.xream.sqli.util.JsonWrapper;
import io.xream.sqli.util.SqliExceptionUtil;
import io.xream.sqli.util.SqliStringUtil;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.sql.NCLOB;

public class OracleDialect
implements Dialect {
    private final Map<String, String> map = new HashMap<String, String>(){
        {
            this.put("${DATE}", "date");
            this.put("${BYTE}", "number(3, 0)");
            this.put("${INT}", "number(10, 0)");
            this.put("${LONG}", "number(18, 0)");
            this.put("${BIG}", "number(19, 2)");
            this.put("${STRING}", "varchar2");
            this.put("${TEXT}", "clob");
            this.put("${LONG_TEXT}", "clob");
            this.put("${INCREAMENT}", "");
            this.put("${ENGINE}", "");
        }
    };
    private static final String ORACLE_PAGINATION = "SELECT * FROM (SELECT A.*, ROWNUM RN FROM ( ${SQL} ) A   WHERE ROWNUM <= ${END}  )  WHERE RN > ${BEGIN} ";
    private static final String ORACLE_PAGINATION_REGX_SQL = "${SQL}";
    private static final String ORACLE_PAGINATION_REGX_BEGIN = "${BEGIN}";
    private static final String ORACLE_PAGINATION_REGX_END = "${END}";

    public String buildPage(String origin, long start, long rows) {
        if (rows > 0L) {
            return ORACLE_PAGINATION.replace(ORACLE_PAGINATION_REGX_END, String.valueOf(start + rows)).replace(ORACLE_PAGINATION_REGX_BEGIN, String.valueOf(start)).replace(ORACLE_PAGINATION_REGX_SQL, origin);
        }
        return origin;
    }

    public String replaceAll(String origin) {
        return this.replace(origin, this.map);
    }

    public Object mappingToObject(Object obj, BeanElement element) {
        if (obj == null) {
            return null;
        }
        Class ec = element.getClz();
        if (element.isJson()) {
            String str = null;
            if (obj instanceof NCLOB) {
                NCLOB clob = (NCLOB)obj;
                Reader reader = null;
                try {
                    reader = clob.getCharacterStream();
                    char[] charArr = new char[(int)clob.length()];
                    reader.read(charArr);
                    str = new String(charArr);
                }
                catch (Exception e) {
                    throw new PersistenceException(SqliExceptionUtil.getMessage((Throwable)e));
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            if (obj instanceof String) {
                str = obj.toString();
            }
            if (SqliStringUtil.isNullOrEmpty(str)) {
                return null;
            }
            if (!(str = str.trim()).startsWith("{") && !str.startsWith("[")) {
                return str;
            }
            if (ec == List.class) {
                Class geneType = element.getGeneType();
                return JsonWrapper.toList((String)str, (Class)geneType);
            }
            if (ec == Map.class) {
                return JsonWrapper.toMap((String)str);
            }
            return JsonWrapper.toObject((String)str, (Class)ec);
        }
        if (obj instanceof BigDecimal) {
            BigDecimal bg = (BigDecimal)obj;
            if (ec == BigDecimal.class) {
                return bg;
            }
            if (ec == Integer.TYPE || ec == Integer.class) {
                return bg.intValue();
            }
            if (ec == Long.TYPE || ec == Long.class) {
                return bg.longValue();
            }
            if (ec == Double.TYPE || ec == Double.class) {
                return bg.doubleValue();
            }
            if (ec == Float.TYPE || ec == Float.class) {
                return Float.valueOf(bg.floatValue());
            }
            if (ec == Boolean.TYPE || ec == Boolean.class) {
                int i = bg.intValue();
                return i != 0;
            }
            if (ec == java.util.Date.class) {
                long l = bg.longValue();
                return new java.util.Date(l);
            }
            if (ec == Date.class) {
                long l = bg.longValue();
                return new Date(l);
            }
            if (ec == Timestamp.class) {
                long l = bg.longValue();
                return new Timestamp(l);
            }
            if (ec == Byte.TYPE || ec == Byte.class) {
                return bg.byteValue();
            }
        } else if (obj instanceof Timestamp && ec == java.util.Date.class) {
            Timestamp ts = (Timestamp)obj;
            return new java.util.Date(ts.getTime());
        }
        if (BeanUtil.isEnum((Class)ec)) {
            return Enum.valueOf(ec, obj.toString());
        }
        return obj;
    }

    public String createOrReplaceSql(String sql) {
        throw new NotSupportedException("sqli not support createOrReplace() for Oracle");
    }

    public String transformAlia(String mapper, Map<String, String> aliaMap, Map<String, String> resultKeyAliaMap) {
        if (resultKeyAliaMap.containsKey(mapper)) {
            mapper = resultKeyAliaMap.get(mapper);
        }
        if (aliaMap.isEmpty()) {
            return mapper;
        }
        if (mapper.contains(".")) {
            String[] arr = mapper.split("\\.");
            String alia = arr[0];
            String p = arr[1];
            String clzName = aliaMap.get(alia);
            if (SqliStringUtil.isNullOrEmpty((String)clzName)) {
                clzName = alia;
            }
            return clzName + "." + p;
        }
        return mapper;
    }

    public Object filterValue(Object object) {
        return this.filter(object, obj -> {
            if (obj instanceof java.util.Date) {
                java.util.Date date = (java.util.Date)obj;
                Timestamp timestamp = new Timestamp(date.getTime());
                return timestamp;
            }
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                return b != false ? 1 : 0;
            }
            return obj;
        });
    }

    public Object[] toArr(Collection<Object> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        int size = list.size();
        Object[] arr = new Object[size];
        int i = 0;
        for (Object obj : list) {
            obj = this.filterValue(obj);
            arr[i++] = obj;
        }
        return arr;
    }
}

