/*
 * Decompiled with CFR 0.152.
 */
package io.xream.sqli.dialect;

import io.xream.sqli.core.Dialect;
import io.xream.sqli.parser.BeanElement;
import io.xream.sqli.util.BeanUtil;
import io.xream.sqli.util.JsonWrapper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MySqlDialect
implements Dialect {
    private final Map<String, String> map = new HashMap<String, String>(){
        {
            this.put("${DATE}", "timestamp");
            this.put("${BYTE}", "tinyint(1)");
            this.put("${INT}", "int(11)");
            this.put("${LONG}", "bigint(13)");
            this.put("${BIG}", "decimal(15,2)");
            this.put("${STRING}", "varchar");
            this.put("${TEXT}", "text");
            this.put("${LONG_TEXT}", "longtext");
            this.put("${INCREAMENT}", "AUTO_INCREMENT");
            this.put("${ENGINE}", "ENGINE=InnoDB DEFAULT CHARSET=utf8");
        }
    };

    public String buildPage(String origin, long start, long rows) {
        if (rows == 0L) {
            return origin;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(origin);
        sb.append(" LIMIT ").append(start).append(",").append(rows);
        return sb.toString();
    }

    public String replaceAll(String origin) {
        return this.replace(origin, this.map);
    }

    public Object mappingToObject(Object obj, BeanElement element) {
        if (obj == null) {
            return null;
        }
        Class ec = element.getClz();
        if (BeanUtil.isEnum((Class)ec)) {
            return Enum.valueOf(ec, obj.toString());
        }
        if (element.isJson()) {
            if (ec == List.class) {
                Class geneType = element.getGeneType();
                return JsonWrapper.toList((String)obj.toString(), (Class)geneType);
            }
            if (ec == Map.class) {
                return JsonWrapper.toMap((Object)obj);
            }
            return JsonWrapper.toObject((String)obj.toString(), (Class)ec);
        }
        if (ec == BigDecimal.class) {
            return new BigDecimal(String.valueOf(obj));
        }
        if (ec == Double.TYPE || ec == Double.class) {
            return Double.valueOf(obj.toString());
        }
        return obj;
    }

    public String createOrReplaceSql(String sql) {
        return sql.replaceFirst("INSERT", "REPLACE");
    }

    public String transformAlia(String mapper, Map<String, String> aliaMap, Map<String, String> resultKeyAliaMap) {
        if (resultKeyAliaMap.containsKey(mapper)) {
            mapper = resultKeyAliaMap.get(mapper);
        }
        return mapper;
    }

    public Object filterValue(Object object) {
        return this.filter(object, null);
    }

    public Object[] toArr(Collection<Object> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        int size = list.size();
        Object[] arr = new Object[size];
        int i = 0;
        for (Object obj : list) {
            obj = this.filterValue(obj);
            arr[i++] = obj;
        }
        return arr;
    }
}

