/*
 * Decompiled with CFR 0.152.
 */
package io.xream.sqli.dialect;

import io.xream.sqli.dialect.Dialect;
import io.xream.sqli.dialect.DynamicDialectHolder;
import io.xream.sqli.parser.BeanElement;
import io.xream.sqli.parser.Parsed;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DynamicDialect
implements Dialect {
    private Dialect defaultDialect;
    private Map<String, Dialect> map = new HashMap<String, Dialect>();

    public void setDefaultDialect(Dialect dialect) {
        this.defaultDialect = dialect;
        this.map.put(dialect.getKey(), dialect);
    }

    public void addDialect(Dialect dialect) {
        this.map.put(dialect.getKey(), dialect);
    }

    public String getKey() {
        String key = DynamicDialectHolder.getDialectKey();
        if (key == null) {
            return this.defaultDialect.getKey();
        }
        Dialect currentDialect = this.map.get(key);
        return currentDialect.getKey();
    }

    private Dialect getCurrentDialect() {
        String key = DynamicDialectHolder.getDialectKey();
        if (key == null) {
            return this.defaultDialect;
        }
        return this.map.get(key);
    }

    public String buildPageSql(String sql, long start, long rows, long last) {
        return this.getCurrentDialect().buildPageSql(sql, start, rows, last);
    }

    @Override
    public String transformAlia(String mapper, Map<String, String> aliaMap, Map<String, String> resultKeyAliaMap) {
        return this.getCurrentDialect().transformAlia(mapper, aliaMap, resultKeyAliaMap);
    }

    public Object filterValue(Object value) {
        return this.getCurrentDialect().filterValue(value);
    }

    @Override
    public Object[] toArr(Collection<Object> list) {
        return this.getCurrentDialect().toArr(list);
    }

    @Override
    public Object mappingToObject(Object obj, BeanElement element) {
        return this.getCurrentDialect().mappingToObject(obj, element);
    }

    @Override
    public String createOrReplaceSql(String sql) {
        return this.getCurrentDialect().createOrReplaceSql(sql);
    }

    @Override
    public String createSql(Parsed parsed, List<BeanElement> tempList) {
        return this.getCurrentDialect().createSql(parsed, tempList);
    }

    public Object convertJsonToPersist(Object json) {
        return this.getCurrentDialect().convertJsonToPersist(json);
    }

    public String getAlterTableUpdate() {
        return this.getCurrentDialect().getAlterTableUpdate();
    }

    public String getAlterTableDelete() {
        return this.getCurrentDialect().getAlterTableDelete();
    }

    public String getCommandUpdate() {
        return this.getCurrentDialect().getCommandUpdate();
    }

    public String getCommandDelete() {
        return this.getCurrentDialect().getCommandDelete();
    }

    public String getLimitOne() {
        return this.getCurrentDialect().getLimitOne();
    }

    public String getInsertTagged() {
        return this.getCurrentDialect().getInsertTagged();
    }

    public void filterTags(List<BeanElement> list, List<Field> tagList) {
        this.getCurrentDialect().filterTags(list, tagList);
    }

    public List<Object> objectToListForCreate(Object obj, Parsed parsed) {
        return this.getCurrentDialect().objectToListForCreate(obj, parsed);
    }
}

