/*
 * Decompiled with CFR 0.152.
 */
package io.xream.sqli.converter;

import io.xream.sqli.dialect.Dialect;
import io.xream.sqli.exception.ParsingException;
import io.xream.sqli.exception.PersistenceException;
import io.xream.sqli.mapping.ResultMapHelpful;
import io.xream.sqli.parser.BeanElement;
import io.xream.sqli.parser.Parsed;
import io.xream.sqli.parser.Parser;
import io.xream.sqli.util.EnumUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DataObjectConverter {
    public static Map<String, Object> toMapWithKeyOfObjectProperty(Map<String, Object> dataMap, Class orClzz, ResultMapHelpful resultMapHelpful, Dialect dialect) {
        if (resultMapHelpful == null && orClzz == null) {
            return dataMap;
        }
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
            Parsed parsed;
            String mapper = entry.getKey();
            String property = null;
            BeanElement be = null;
            if (resultMapHelpful == null) {
                parsed = Parser.get((Class)orClzz);
                property = parsed.getPropertyByLower(mapper);
                be = parsed.getElement(property);
            } else if (mapper.contains("$")) {
                property = dialect.transformAlia(mapper, resultMapHelpful.getAliaMap(), resultMapHelpful.getResultKeyAliaMap());
            } else {
                mapper = dialect.transformAlia(mapper, resultMapHelpful.getAliaMap(), resultMapHelpful.getResultKeyAliaMap());
                property = (String)resultMapHelpful.getMapperPropertyMap().get(mapper);
                if (property == null) {
                    property = mapper;
                } else if (property.contains(".")) {
                    String[] arr = property.split("\\.");
                    String clzName = (String)resultMapHelpful.getAliaMap().get(arr[0]);
                    Parsed parsed2 = Parser.get((String)clzName);
                    if (parsed2 == null) {
                        throw new ParsingException("clzName: " + clzName + ",alia: " + arr[0] + ", property: " + arr[1]);
                    }
                    be = parsed2.getElement(arr[1]);
                } else {
                    parsed = Parser.get((Class)orClzz);
                    be = parsed.getElement(property);
                }
            }
            Object value = entry.getValue();
            value = DataObjectConverter.filter(value);
            if (be != null) {
                value = dialect.mappingToObject(value, be);
            }
            propertyMap.put(property, value);
        }
        return propertyMap;
    }

    public static <T> void initObj(T obj, Map<String, Object> map, List<BeanElement> eles, Dialect dialect) throws Exception {
        for (BeanElement ele : eles) {
            Method method = ele.getSetMethod();
            String mapper = ele.getMapper();
            Object value = map.get(mapper);
            if (value == null) {
                if (!EnumUtil.isEnum((Class)ele.getClz())) continue;
                throw new PersistenceException("ENUM CAN NOT NULL, property:" + obj.getClass().getName() + "." + ele.getProperty());
            }
            value = DataObjectConverter.filter(value);
            Object v = dialect.mappingToObject(value, ele);
            method.invoke(obj, v);
        }
    }

    private static Object filter(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String str = (String)value;
            value = str.replace("<", "&lt").replace(">", "&gt");
        }
        return value;
    }
}

