/*
 * Decompiled with CFR 0.152.
 */
package io.xream.sqli.cache.internal;

import io.xream.sqli.builder.Criteria;
import io.xream.sqli.builder.InCondition;
import io.xream.sqli.cache.QueryForCache;
import io.xream.sqli.cache.internal.CriteriaCacheKeyBuilder;
import io.xream.sqli.exception.L2CacheException;
import io.xream.sqli.exception.NoResultUnderProtectionException;
import io.xream.sqli.exception.NotQueryUnderProtectionException;
import io.xream.sqli.page.Page;
import io.xream.sqli.parser.Parsed;
import io.xream.sqli.parser.Parser;
import io.xream.sqli.spi.L2CacheConsistency;
import io.xream.sqli.spi.L2CacheResolver;
import io.xream.sqli.spi.L2CacheStorage;
import io.xream.sqli.util.ParserUtil;
import io.xream.sqli.util.SqliExceptionUtil;
import io.xream.sqli.util.SqliJsonUtil;
import io.xream.sqli.util.SqliStringUtil;
import java.lang.reflect.Field;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultL2CacheResolver
extends CriteriaCacheKeyBuilder
implements L2CacheResolver {
    private static final Logger logger = LoggerFactory.getLogger(DefaultL2CacheResolver.class);
    private static L2CacheResolver instance;
    public static final String NANO_SECOND = ".ns.";
    private static int validSecond;
    private static boolean isEnabled;
    private L2CacheStorage cacheStorage;
    private L2CacheConsistency l2CacheConsistency;

    private DefaultL2CacheResolver() {
    }

    public static L2CacheResolver newInstance() {
        if (instance == null) {
            instance = new DefaultL2CacheResolver();
            return instance;
        }
        return null;
    }

    @Override
    public void setL2CacheConsistency(L2CacheConsistency l2CacheConsistency) {
        this.l2CacheConsistency = l2CacheConsistency;
    }

    public static void enabled() {
        isEnabled = true;
    }

    @Override
    public boolean isEnabled() {
        return isEnabled;
    }

    public static void setValidSecond(int vs) {
        validSecond = vs;
        logger.info("L2 Cache try to starting.... cache time = {}s", (Object)validSecond);
    }

    private int getValidSecondAdjusted() {
        return validSecond;
    }

    @Override
    public void setCacheStorage(L2CacheStorage cacheStorage) {
        this.cacheStorage = cacheStorage;
    }

    protected L2CacheStorage getCachestorage() {
        if (this.cacheStorage == null) {
            throw new L2CacheException("No implements of L2CacheStorage, like the project x7-repo/x7-redis-integration");
        }
        return this.cacheStorage;
    }

    private String getGroupedKey(String nsKey) {
        return nsKey + this.getFilterFactor();
    }

    @Override
    public String markForRefresh(Class clzz) {
        String str = this.markForRefresh0(clzz);
        this.close();
        return str;
    }

    public String markForRefresh0(Class clz) {
        String key = this.getNSKey(clz);
        String time = String.valueOf(System.nanoTime());
        if (this.l2CacheConsistency != null) {
            this.l2CacheConsistency.markForRefresh(key);
        }
        this.getCachestorage().set(key, time);
        if (this.getFilterFactor() != null) {
            String groupedKey = this.getGroupedKey(key);
            if (this.l2CacheConsistency != null) {
                this.l2CacheConsistency.markForRefresh(groupedKey);
            }
            this.getCachestorage().set(groupedKey, time);
        }
        return time;
    }

    @Override
    public boolean refresh(Class clz, String cacheKey) {
        if (cacheKey == null) {
            this.remove(clz);
        } else {
            this.remove(clz, cacheKey);
        }
        this.markForRefresh0(clz);
        this.close();
        return true;
    }

    @Override
    public boolean refresh(Class clz) {
        return this.refresh(clz, null);
    }

    public void remove(Class clz, String cacheKey) {
        String key = this.getSimpleKey(clz, cacheKey);
        if (this.l2CacheConsistency != null) {
            this.l2CacheConsistency.remove(key);
        }
        this.getCachestorage().delete(key);
    }

    public void remove(Class clz) {
        String key = this.getSimpleKeyLike(clz);
        Set<String> keySet = this.getCachestorage().keys(key);
        if (this.l2CacheConsistency != null) {
            this.l2CacheConsistency.remove(keySet);
        }
        for (String k : keySet) {
            this.getCachestorage().delete(k);
        }
    }

    private String getNSKeyReadable(Class clz) {
        if (this.getFilterFactor() == null) {
            return clz.getName() + NANO_SECOND;
        }
        String str = clz.getName() + NANO_SECOND + this.getFilterFactor();
        return str;
    }

    private String getNSKey(Class clz) {
        return clz.getName() + NANO_SECOND;
    }

    private String getNSReadable(Class clzz) {
        String nsKey = this.getNSKeyReadable(clzz);
        String ns = this.getCachestorage().get(nsKey);
        if (SqliStringUtil.isNullOrEmpty((String)ns)) {
            ns = String.valueOf(System.nanoTime());
            this.getCachestorage().set(nsKey, ns);
        }
        if (this.getFilterFactor() == null) {
            return ns;
        }
        return this.getFilterFactor() + ns;
    }

    private List<String> getKeyList(Class clz, List<String> conditionSet) {
        if (conditionSet == null || conditionSet.isEmpty()) {
            return null;
        }
        ArrayList<String> keyList = new ArrayList<String>();
        for (String condition : conditionSet) {
            String key = this.getSimpleKey(clz, condition);
            keyList.add(key);
        }
        if (keyList.isEmpty()) {
            return null;
        }
        return keyList;
    }

    private String getSimpleKey(Class clz, String condition) {
        return "{" + clz.getName() + "}." + condition;
    }

    private String getTotalRowsKey(Class clz, String condition) {
        condition = MD5Helper.toMD5(condition) + "~TR";
        return "{" + clz.getName() + "}." + this.getNSReadable(clz) + "." + condition;
    }

    private String getConditionedKey(Class clz, String condition) {
        condition = MD5Helper.toMD5(condition) + "~C";
        return "{" + clz.getName() + "}." + this.getNSReadable(clz) + condition;
    }

    private String getSimpleKeyLike(Class clz) {
        return "{" + clz.getName() + "}.*";
    }

    private String getKeyForOneObject(Class clz, Object condition) {
        if (condition == null) {
            throw new L2CacheException("getKeyForOneObject, id = " + condition);
        }
        return this.getPrefixForOneObject(clz) + "." + MD5Helper.toMD5("" + condition);
    }

    private String getPrefixForOneObject(Class clz) {
        String nsStr = this.getNSReadable(clz);
        if (nsStr == null) {
            String str = this.markForRefresh0(clz);
            return "{" + clz.getName() + "}." + str;
        }
        return "{" + clz.getName() + "}." + nsStr;
    }

    private void setTotalRows(Class clz, String cacheKey, long obj) {
        String key = this.getTotalRowsKey(clz, cacheKey);
        int validSecond = this.getValidSecondAdjusted();
        this.getCachestorage().set(key, String.valueOf(obj), validSecond, TimeUnit.SECONDS);
    }

    private void setResultKeyList(Class clz, Object condition, List<String> keyList) {
        String key = this.getConditionedKey(clz, condition.toString());
        try {
            int validSecond = this.getValidSecondAdjusted();
            this.getCachestorage().set(key, SqliJsonUtil.toJson(keyList), validSecond, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            this.throwException(e);
        }
    }

    private <T> void setResultKeyListPaginated(Class<T> clz, Object condition, Page<T> pagination) {
        String key = this.getConditionedKey(clz, condition.toString());
        try {
            int validSecond = this.getValidSecondAdjusted();
            this.getCachestorage().set(key, SqliJsonUtil.toJson(pagination), validSecond, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            this.throwException(e);
        }
    }

    private List<String> getResultKeyList(Class clz, Object condition) throws NotQueryUnderProtectionException {
        String key = this.getConditionedKey(clz, condition.toString());
        String str = this.getCachestorage().get(key);
        if (SqliStringUtil.isNullOrEmpty((String)str)) {
            throw new NotQueryUnderProtectionException();
        }
        return SqliJsonUtil.toList((String)str, String.class);
    }

    private Page<String> getResultKeyListPaginated(Class clz, Object condition) {
        String key = this.getConditionedKey(clz, condition.toString());
        String json = this.getCachestorage().get(key);
        if (SqliStringUtil.isNullOrEmpty((String)json)) {
            return null;
        }
        return this.toPagination(json);
    }

    private <T> Page<T> toPagination(String json) {
        if (SqliStringUtil.isNullOrEmpty((String)json)) {
            return null;
        }
        Page pagination = (Page)SqliJsonUtil.toObject((String)json, Page.class);
        return pagination;
    }

    private <T> List<T> list(Class<T> clz, List<String> keyList) {
        List<String> keyArr = this.getKeyList(clz, keyList);
        List<String> jsonList = this.getCachestorage().multiGet(keyArr);
        if (jsonList == null) {
            return new ArrayList();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (String json : jsonList) {
            if (!SqliStringUtil.isNotNull((String)json)) continue;
            Object t = SqliJsonUtil.toObject((String)json, clz);
            list.add(t);
        }
        return list;
    }

    private <T> T get(Class<T> clz, Object cacheKey) throws NoResultUnderProtectionException {
        String k = this.getSimpleKey(clz, cacheKey.toString());
        String str = this.getCachestorage().get(k);
        if (SqliStringUtil.isNullOrEmpty((String)str)) {
            return null;
        }
        if (str.trim().equals("NULL")) {
            throw new NoResultUnderProtectionException();
        }
        return (T)SqliJsonUtil.toObject((String)str, clz);
    }

    private void set(Class clz, Object cacheKey, Object obj) {
        if (cacheKey == null) {
            return;
        }
        String k = this.getSimpleKey(clz, cacheKey.toString());
        String v = SqliJsonUtil.toJson((Object)(obj == null ? "NULL" : obj));
        this.getCachestorage().set(k, v, validSecond, TimeUnit.SECONDS);
    }

    private void setOne(Class clz, Object condition, Object obj) {
        String key = this.getKeyForOneObject(clz, condition);
        Object objKey = null;
        if (obj != null) {
            Parsed parsed = Parser.get((Class)clz);
            Field field = parsed.getKeyField();
            field.setAccessible(true);
            try {
                objKey = field.get(obj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.doSetKeyOne(clz, key, objKey, obj);
    }

    private void doSetKeyOne(Class clz, String cacheKey, Object objKey, Object obj) {
        int validSecond = this.getValidSecondAdjusted();
        this.getCachestorage().set(cacheKey, objKey == null ? "NULL" : objKey.toString(), validSecond, TimeUnit.SECONDS);
        this.set(clz, objKey, obj);
    }

    private <T> T getOne(Class<T> clz, Object condition) throws NoResultUnderProtectionException {
        String key = this.getKeyForOneObject(clz, condition);
        String keyOne = this.doGetKeyOne(key);
        if (keyOne == null) {
            return null;
        }
        return this.get(clz, keyOne);
    }

    private <T> String doGetKeyOne(String cacheKey) throws NoResultUnderProtectionException {
        String str = this.getCachestorage().get(cacheKey);
        if (SqliStringUtil.isNullOrEmpty((String)str)) {
            return null;
        }
        if (str.trim().equals("NULL")) {
            throw new NoResultUnderProtectionException();
        }
        return str;
    }

    private <T> long getTotalRows(Class<T> clz, String cacheKey) {
        String key = this.getTotalRowsKey(clz, cacheKey);
        String str = this.getCachestorage().get(key);
        if (SqliStringUtil.isNullOrEmpty((String)str)) {
            return Integer.MIN_VALUE;
        }
        return Long.valueOf(str);
    }

    @Override
    public <T> List<T> listUnderProtection(Class<T> clz, Object conditionObj, QueryForCache queryForCache, L2CacheResolver.QueryFromDb<List<T>> QueryFromDb2) {
        Parsed parsed = Parser.get(clz);
        List<String> keyList = null;
        try {
            keyList = this.getResultKeyList(clz, conditionObj);
        }
        catch (NotQueryUnderProtectionException notQueryUnderProtectionException) {
            // empty catch block
        }
        if (keyList == null) {
            List<T> list = null;
            try {
                list = QueryFromDb2.query();
            }
            catch (Exception e) {
                this.close();
                this.throwException(e);
            }
            keyList = new ArrayList<String>();
            for (T t : list) {
                String key = ParserUtil.getCacheKey(t, (Parsed)parsed);
                keyList.add(key);
            }
            this.setResultKeyList(clz, conditionObj, keyList);
            this.close();
            return list;
        }
        if (keyList.isEmpty()) {
            this.close();
            return new ArrayList();
        }
        List<T> list = this.list(clz, keyList);
        if (keyList.size() == list.size()) {
            this.close();
            return list;
        }
        this.replenishAndRefreshCache(keyList, list, clz, parsed, queryForCache);
        List<T> sortedList = this.sort(keyList, list, parsed);
        this.close();
        return sortedList;
    }

    @Override
    public <T> List<T> listUnderProtection(Criteria criteria, QueryForCache queryForCache, L2CacheResolver.QueryFromDb<List<T>> QueryFromDb2) {
        String criteriaKey = this.buildCacheKey(criteria);
        Class clz = criteria.getClzz();
        List<String> keyList = null;
        try {
            keyList = this.getResultKeyList(clz, criteriaKey);
        }
        catch (NotQueryUnderProtectionException notQueryUnderProtectionException) {
            // empty catch block
        }
        Parsed parsed = Parser.get((Class)clz);
        if (keyList == null) {
            List<T> list = null;
            try {
                list = QueryFromDb2.query();
            }
            catch (Exception e) {
                this.close();
                this.throwException(e);
            }
            keyList = new ArrayList<String>();
            for (T t : list) {
                String key = ParserUtil.getCacheKey(t, (Parsed)parsed);
                keyList.add(key);
            }
            this.setResultKeyList(clz, criteriaKey, keyList);
            this.close();
            return list;
        }
        if (keyList.isEmpty()) {
            this.close();
            return new ArrayList();
        }
        List<T> list = this.list(clz, keyList);
        if (keyList.size() == list.size()) {
            this.close();
            return list;
        }
        this.replenishAndRefreshCache(keyList, list, clz, parsed, queryForCache);
        List<T> sortedList = this.sort(keyList, list, parsed);
        this.close();
        return sortedList;
    }

    @Override
    public <T> T getUnderProtection(Class<T> clz, Object conditionObj, L2CacheResolver.QueryFromDb<T> QueryFromDb2) {
        T obj;
        try {
            obj = this.get(clz, conditionObj);
        }
        catch (NoResultUnderProtectionException e) {
            this.close();
            return null;
        }
        if (obj == null) {
            try {
                obj = QueryFromDb2.query();
            }
            catch (Exception e) {
                this.close();
                this.throwException(e);
            }
            this.set(clz, conditionObj, obj);
        }
        this.close();
        return obj;
    }

    @Override
    public <T> T getOneUnderProtection(Class<T> clz, Object conditionObj, L2CacheResolver.QueryFromDb<T> QueryFromDb2) {
        T obj;
        try {
            obj = this.getOne(clz, conditionObj);
        }
        catch (NoResultUnderProtectionException e) {
            this.close();
            return null;
        }
        if (obj == null) {
            try {
                obj = QueryFromDb2.query();
            }
            catch (Exception e) {
                this.close();
                this.throwException(e);
            }
            this.setOne(clz, conditionObj, obj);
        }
        this.close();
        return obj;
    }

    @Override
    public <T> Page<T> findUnderProtection(Criteria criteria, QueryForCache queryForCache, L2CacheResolver.QueryFromDb<Page<T>> findQueryFromDb, L2CacheResolver.QueryFromDb<List<T>> listQueryFromDb) {
        Class clz = criteria.getClzz();
        Parsed parsed = Parser.get((Class)clz);
        String criteriaKey = this.buildCacheKey(criteria);
        Page<String> p = this.getResultKeyListPaginated(clz, criteriaKey);
        if (p == null) {
            if (!criteria.isTotalRowsIgnored()) {
                String totalRowsString = this.buildCacheKeyOfTotalRows(criteria);
                long totalRows = this.getTotalRows(clz, totalRowsString);
                if (totalRows == Integer.MIN_VALUE) {
                    try {
                        p = findQueryFromDb.query();
                    }
                    catch (Exception e) {
                        this.close();
                        this.throwException(e);
                    }
                    this.setTotalRows(clz, totalRowsString, p.getTotalRows());
                } else {
                    List<T> list = null;
                    try {
                        list = listQueryFromDb.query();
                    }
                    catch (Exception e) {
                        this.close();
                        SqliExceptionUtil.throwRuntimeExceptionFirst((Throwable)e);
                        throw new L2CacheException(SqliExceptionUtil.getMessage((Throwable)e));
                    }
                    p = new Page();
                    p.setTotalRows(totalRows);
                    p.setPage(criteria.getPage());
                    p.setRows(criteria.getRows());
                    p.reSetList(list);
                }
            } else {
                try {
                    p = findQueryFromDb.query();
                }
                catch (Exception e) {
                    this.close();
                    this.throwException(e);
                }
            }
            List list = p.getList();
            ArrayList<String> keyList = new ArrayList<String>();
            for (Object t : list) {
                String key = ParserUtil.getCacheKey(t, (Parsed)parsed);
                keyList.add(key);
            }
            p.setKeyList(keyList);
            p.reSetList(null);
            this.setResultKeyListPaginated(clz, criteriaKey, p);
            p.setKeyList(null);
            p.reSetList(list);
            this.close();
            return p;
        }
        List keyList = p.getKeyList();
        if (keyList == null || keyList.isEmpty()) {
            this.close();
            return p;
        }
        List<T> list = this.list(clz, keyList);
        if (keyList.size() == list.size()) {
            p.reSetList(list);
            this.close();
            return p;
        }
        this.replenishAndRefreshCache(keyList, list, clz, parsed, queryForCache);
        List<T> sortedList = this.sort(keyList, list, parsed);
        p.reSetList(sortedList);
        this.close();
        return p;
    }

    private <T> void replenishAndRefreshCache(List<String> keyList, List<T> list, Class<T> clz, Parsed parsed, QueryForCache queryForCache) {
        HashSet<String> keySet = new HashSet<String>();
        for (T t : list) {
            String key = ParserUtil.getCacheKey(t, (Parsed)parsed);
            keySet.add(key);
        }
        Field f = parsed.getKeyField();
        Class<?> keyClz = f.getType();
        ArrayList<Object> idList = new ArrayList<Object>();
        for (String key : keyList) {
            if (keySet.contains(key)) continue;
            try {
                if (keyClz == String.class) {
                    idList.add(key);
                    continue;
                }
                if (keyClz == Long.TYPE || keyClz == Long.class) {
                    idList.add(Long.valueOf(key));
                    continue;
                }
                if (keyClz != Integer.TYPE && keyClz != Integer.class) continue;
                idList.add(Integer.valueOf(key));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String key = parsed.getKey();
        InCondition inCondition = InCondition.of((String)key, idList);
        inCondition.setClz(clz);
        List objList = queryForCache.in(inCondition);
        if (objList.isEmpty()) {
            this.markForRefresh0(clz);
            return;
        }
        try {
            for (Object obj : objList) {
                list.add(obj);
                Object id = f.get(obj);
                this.set(clz, String.valueOf(id), obj);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private <T> List<T> sort(List<String> keyList, List<T> list, Parsed parsed) {
        ArrayList<T> sortedList = new ArrayList<T>();
        block0: for (String key : keyList) {
            Iterator<T> ite = list.iterator();
            while (ite.hasNext()) {
                T t = ite.next();
                if (!key.equals(ParserUtil.getCacheKey(t, (Parsed)parsed))) continue;
                ite.remove();
                sortedList.add(t);
                continue block0;
            }
        }
        return sortedList;
    }

    private void throwException(Exception e) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new L2CacheException(SqliExceptionUtil.getMessage((Throwable)e));
    }

    public static final class MD5Helper {
        public static String toMD5(String str) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(str.getBytes());
                byte[] byteDigest = md.digest();
                StringBuffer buf = new StringBuffer("");
                int i = 0;
                for (int offset = 0; offset < byteDigest.length; ++offset) {
                    i = byteDigest[offset];
                    if (i < 0) {
                        i += 256;
                    }
                    if (i < 16) {
                        buf.append("0");
                    }
                    buf.append(Integer.toHexString(i));
                }
                return buf.toString();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                return null;
            }
        }
    }
}

