/*
 * Decompiled with CFR 0.152.
 */
package io.xream.sqli.dialect;

import io.xream.sqli.dialect.Dialect;
import io.xream.sqli.dialect.DynamicDialectHolder;
import io.xream.sqli.parser.BeanElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class DynamicDialect
implements Dialect {
    private Dialect defaultDialect;
    private Map<String, Dialect> map = new HashMap<String, Dialect>();

    public void setDefaultDialect(Dialect dialect) {
        if (this.defaultDialect != null) {
            throw new IllegalArgumentException();
        }
        this.defaultDialect = dialect;
        this.map.put(dialect.getKey(), dialect);
    }

    public void addDialect(Dialect dialect) {
        this.map.put(dialect.getKey(), dialect);
    }

    public String getKey() {
        String key = DynamicDialectHolder.getDialectKey();
        if (key == null) {
            return this.defaultDialect.getKey();
        }
        Dialect currentDialect = this.map.get(key);
        return currentDialect.getKey();
    }

    @Override
    public String buildPage(String sql, long start, long rows) {
        String key = DynamicDialectHolder.getDialectKey();
        if (key == null) {
            return this.defaultDialect.buildPage(sql, start, rows);
        }
        Dialect currentDialect = this.map.get(key);
        return currentDialect.buildPage(sql, start, rows);
    }

    @Override
    public String replaceAll(String sql) {
        String key = DynamicDialectHolder.getDialectKey();
        if (key == null) {
            return this.defaultDialect.replaceAll(sql);
        }
        Dialect currentDialect = this.map.get(key);
        return currentDialect.replaceAll(sql);
    }

    @Override
    public String transformAlia(String mapper, Map<String, String> aliaMap, Map<String, String> resultKeyAliaMap) {
        String key = DynamicDialectHolder.getDialectKey();
        if (key == null) {
            return this.defaultDialect.transformAlia(mapper, aliaMap, resultKeyAliaMap);
        }
        Dialect currentDialect = this.map.get(key);
        return currentDialect.transformAlia(mapper, aliaMap, resultKeyAliaMap);
    }

    @Override
    public Object filterValue(Object value) {
        String key = DynamicDialectHolder.getDialectKey();
        if (key == null) {
            return this.defaultDialect.filterValue(value);
        }
        Dialect currentDialect = this.map.get(key);
        return currentDialect.filterValue(value);
    }

    @Override
    public Object[] toArr(Collection<Object> list) {
        String key = DynamicDialectHolder.getDialectKey();
        if (key == null) {
            return this.defaultDialect.toArr(list);
        }
        Dialect currentDialect = this.map.get(key);
        return currentDialect.toArr(list);
    }

    @Override
    public Object mappingToObject(Object obj, BeanElement element) {
        String key = DynamicDialectHolder.getDialectKey();
        if (key == null) {
            return this.defaultDialect.mappingToObject(obj, element);
        }
        Dialect currentDialect = this.map.get(key);
        return currentDialect.mappingToObject(obj, element);
    }

    @Override
    public String createOrReplaceSql(String sql) {
        String key = DynamicDialectHolder.getDialectKey();
        if (key == null) {
            return this.defaultDialect.createOrReplaceSql(sql);
        }
        Dialect currentDialect = this.map.get(key);
        return currentDialect.createOrReplaceSql(sql);
    }

    public Object convertJsonToPersist(Object json) {
        String key = DynamicDialectHolder.getDialectKey();
        if (key == null) {
            return this.defaultDialect.convertJsonToPersist(json);
        }
        Dialect currentDialect = this.map.get(key);
        return currentDialect.convertJsonToPersist(json);
    }

    public String getAlterTableUpdate() {
        String key = DynamicDialectHolder.getDialectKey();
        if (key == null) {
            return this.defaultDialect.getAlterTableUpdate();
        }
        Dialect currentDialect = this.map.get(key);
        return currentDialect.getAlterTableUpdate();
    }

    public String getAlterTableDelete() {
        String key = DynamicDialectHolder.getDialectKey();
        if (key == null) {
            return this.defaultDialect.getAlterTableDelete();
        }
        Dialect currentDialect = this.map.get(key);
        return currentDialect.getAlterTableDelete();
    }

    public String getCommandUpdate() {
        String key = DynamicDialectHolder.getDialectKey();
        if (key == null) {
            return this.defaultDialect.getCommandUpdate();
        }
        Dialect currentDialect = this.map.get(key);
        return currentDialect.getCommandUpdate();
    }

    public String getCommandDelete() {
        String key = DynamicDialectHolder.getDialectKey();
        if (key == null) {
            return this.defaultDialect.getCommandDelete();
        }
        Dialect currentDialect = this.map.get(key);
        return currentDialect.getCommandDelete();
    }

    public String getTemporaryTableCreate() {
        String key = DynamicDialectHolder.getDialectKey();
        if (key == null) {
            return this.defaultDialect.getTemporaryTableCreate();
        }
        Dialect currentDialect = this.map.get(key);
        return currentDialect.getTemporaryTableCreate();
    }
}

