/*
 * Decompiled with CFR 0.152.
 */
package io.xream.sqli.converter;

import io.xream.sqli.dialect.Dialect;
import io.xream.sqli.exception.ParsingException;
import io.xream.sqli.exception.PersistenceException;
import io.xream.sqli.parser.BeanElement;
import io.xream.sqli.parser.Parsed;
import io.xream.sqli.util.BeanUtil;
import io.xream.sqli.util.JsonWrapper;
import io.xream.sqli.util.SqliExceptionUtil;
import io.xream.sqli.util.SqliLoggerProxy;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class ObjectDataConverter {
    public static List<Object> objectToListForCreate(Object obj, List<BeanElement> eles, Dialect dialect) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            for (BeanElement ele : eles) {
                String str;
                Object value = ele.getGetMethod().invoke(obj, new Object[0]);
                Class clz = ele.getClz();
                if (value == null) {
                    if (BeanUtil.isEnum((Class)clz)) {
                        throw new PersistenceException("ENUM CAN NOT NULL, property:" + obj.getClass().getName() + "." + ele.getProperty());
                    }
                    if (clz == Boolean.class || clz == Integer.class || clz == Long.class || clz == Double.class || clz == Float.class || clz == BigDecimal.class || clz == Byte.class || clz == Short.class) {
                        list.add(0);
                        continue;
                    }
                    list.add(null);
                    continue;
                }
                if (ele.isJson()) {
                    str = JsonWrapper.toJson((Object)value);
                    Object jsonStr = dialect.convertJsonToPersist(str);
                    list.add(jsonStr);
                    continue;
                }
                if (BeanUtil.isEnum((Class)clz)) {
                    str = ((Enum)value).name();
                    list.add(str);
                    continue;
                }
                value = dialect.filterValue(value);
                list.add(value);
            }
        }
        catch (Exception e) {
            SqliExceptionUtil.throwRuntimeExceptionFirst((Throwable)e);
            throw new ParsingException(SqliExceptionUtil.getMessage((Throwable)e));
        }
        return list;
    }

    public static Map<String, Object> objectToMap(Parsed parsed, Object obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (Objects.isNull(obj)) {
            return map;
        }
        Class<?> clz = obj.getClass();
        try {
            for (BeanElement element : parsed.getBeanElementList()) {
                Method method = element.getGetMethod();
                Object value = method.invoke(obj, new Object[0]);
                if (value == null) continue;
                Class<?> type = method.getReturnType();
                String property = element.getProperty();
                if (type == Integer.TYPE) {
                    if ((Integer)value == 0) continue;
                    map.put(property, value);
                    continue;
                }
                if (type == Integer.class) {
                    map.put(property, value);
                    continue;
                }
                if (type == Long.TYPE) {
                    if ((Long)value == 0L) continue;
                    map.put(property, value);
                    continue;
                }
                if (type == Long.class) {
                    map.put(property, value);
                    continue;
                }
                if (type == Double.TYPE) {
                    if ((Double)value == 0.0) continue;
                    map.put(property, value);
                    continue;
                }
                if (type == Double.class) {
                    map.put(property, value);
                    continue;
                }
                if (type == Float.TYPE) {
                    if (((Float)value).floatValue() == 0.0f) continue;
                    map.put(property, value);
                    continue;
                }
                if (type == Float.class) {
                    map.put(property, value);
                    continue;
                }
                if (type == Boolean.TYPE) {
                    if (!((Boolean)value).booleanValue()) continue;
                    map.put(property, value);
                    continue;
                }
                if (type == Boolean.class) {
                    map.put(property, value);
                    continue;
                }
                if (type == String.class) {
                    map.put(property, value);
                    continue;
                }
                if (BeanUtil.isEnum(type)) {
                    map.put(property, ((Enum)value).name());
                    continue;
                }
                if (type == java.util.Date.class || clz == Date.class || type == Timestamp.class) {
                    map.put(property, value);
                    continue;
                }
                if (type == BigDecimal.class) {
                    map.put(property, value);
                    continue;
                }
                if (element.isJson()) {
                    String str = JsonWrapper.toJson((Object)value);
                    map.put(property, str);
                    continue;
                }
                map.put(property, value);
            }
        }
        catch (Exception e) {
            SqliExceptionUtil.throwRuntimeExceptionFirst((Throwable)e);
            throw new ParsingException(SqliExceptionUtil.getMessage((Throwable)e));
        }
        return map;
    }

    public static void log(Class clz, List<Object> valueList) {
        SqliLoggerProxy.debug((Class)clz, valueList);
    }
}

