/*
 * Decompiled with CFR 0.152.
 */
package io.xream.sqli.cache.internal;

import io.xream.sqli.builder.Bb;
import io.xream.sqli.builder.Criteria;
import io.xream.sqli.builder.KV;
import io.xream.sqli.builder.Sort;
import io.xream.sqli.cache.CriteriaCacheKeyBuildable;
import io.xream.sqli.util.SqliStringUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class CriteriaCacheKeyBuilder
implements CriteriaCacheKeyBuildable {
    @Override
    public String buildCacheKey(Criteria criteria, boolean isOfTotalRows) {
        StringBuilder sb = new StringBuilder();
        sb.append(criteria.getRouteKey());
        this.buildCacheKeyByBbList(criteria.getBbList(), sb);
        if (!isOfTotalRows) {
            sb.append(criteria.getPage()).append(criteria.getRows());
            if (criteria.getSortList() != null) {
                for (Sort sort : criteria.getSortList()) {
                    sb.append(sort.getOrderBy()).append(sort.getDirection());
                }
            }
            if (criteria.getFixedSortList() != null) {
                for (KV kv : criteria.getFixedSortList()) {
                    sb.append(kv.k).append(kv.v);
                }
            }
        }
        return sb.toString();
    }

    private void buildCacheKeyByBbBlock(Bb bb, StringBuilder sb) {
        List subList;
        sb.append(bb.getC()).append(bb.getP());
        if (SqliStringUtil.isNotNull((String)bb.getKey()) || Objects.nonNull(bb.getValue())) {
            sb.append(bb.getKey()).append(bb.getValue());
        }
        if ((subList = bb.getSubList()) != null && !subList.isEmpty()) {
            this.buildCacheKeyByBbList(subList, sb);
        }
    }

    private void buildCacheKeyByBbList(List<Bb> bbList, StringBuilder sb) {
        int size = bbList.size();
        if (size == 0) {
            return;
        }
        if (size == 1) {
            Bb bb = bbList.get(0);
            this.buildCacheKeyByBbBlock(bb, sb);
        } else {
            HashSet<Bb> set = new HashSet<Bb>();
            for (Bb bb : bbList) {
                set.add(bb);
            }
            for (Bb bb : set) {
                this.buildCacheKeyByBbBlock(bb, sb);
            }
        }
    }
}

