/*
 * Decompiled with CFR 0.152.
 */
package io.xream.sqli.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class JsonStyleMapUtil {
    private JsonStyleMapUtil() {
    }

    public static Map<String, Object> toJsonableMap(Map<String, Object> stringKeyMap) {
        HashMap<String, Object> jsonableMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> es : stringKeyMap.entrySet()) {
            String stringKey = es.getKey();
            if (stringKey.contains(".")) {
                stringKey = stringKey.replace(".", "->");
                String[] arr = stringKey.split("->");
                String jsonKey = arr[0];
                String propKey = arr[1];
                Object obj = jsonableMap.get(jsonKey);
                HashMap<String, Object> objMap = null;
                if (Objects.isNull(obj)) {
                    objMap = new HashMap<String, Object>();
                    jsonableMap.put(jsonKey, objMap);
                } else {
                    objMap = (HashMap<String, Object>)obj;
                }
                objMap.put(propKey, es.getValue());
                continue;
            }
            jsonableMap.put(stringKey, es.getValue());
        }
        return jsonableMap;
    }

    public static List<Map<String, Object>> toJsonableMapList(List<Map<String, Object>> stringKeyList) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> map : stringKeyList) {
            Map<String, Object> jsonKeyMap = JsonStyleMapUtil.toJsonableMap(map);
            list.add(jsonKeyMap);
        }
        return list;
    }
}

