/*
 * Decompiled with CFR 0.152.
 */
package io.xream.sqli.parser;

import io.xream.sqli.annotation.X;
import io.xream.sqli.builder.Criteria;
import io.xream.sqli.exception.ParsingException;
import io.xream.sqli.parser.BeanElement;
import io.xream.sqli.parser.Parsed;
import io.xream.sqli.util.BeanUtil;
import io.xream.sqli.util.ParserUtil;
import io.xream.sqli.util.SqliExceptionUtil;
import io.xream.sqli.util.SqliStringUtil;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Parser {
    private static Logger logger = LoggerFactory.getLogger(Parser.class);
    private static final Map<Class, Parsed> map = new ConcurrentHashMap<Class, Parsed>();
    private static final Map<String, Parsed> simpleNameMap = new ConcurrentHashMap<String, Parsed>();
    public static String mappingPrefix;
    public static String mappingSpec;

    public static void put(Class clz, Parsed parsed) {
        map.put(clz, parsed);
        String key = BeanUtil.getByFirstLower(clz.getSimpleName());
        simpleNameMap.put(key, parsed);
    }

    public static Parsed get(Class clz) {
        Parsed parsed = map.get(clz);
        if (parsed == null) {
            Parser.parse(clz);
            parsed = map.get(clz);
            Field f = parsed.getKeyField(1);
            if (f == null) {
                throw new ParsingException("No Primary Key, class: " + clz.getName());
            }
        }
        return parsed;
    }

    public static Parsed get(String simpleName) {
        return simpleNameMap.get(simpleName);
    }

    private static void parseElement(Class clz, Parsed parsed, List<BeanElement> elementList) {
        boolean isNoSpec;
        block5: {
            for (BeanElement beanElement : elementList) {
                if (!SqliStringUtil.isNullOrEmpty(beanElement.getMapper())) continue;
                beanElement.initMaper();
            }
            isNoSpec = true;
            try {
                if (SqliStringUtil.isNotNull(mappingSpec)) {
                    isNoSpec = false;
                    break block5;
                }
                for (BeanElement element : elementList) {
                    if (element.getProperty().equals(element.getMapper())) continue;
                    isNoSpec = false;
                    break;
                }
            }
            catch (Exception exception) {
                logger.info(SqliExceptionUtil.getMessage(exception));
            }
        }
        parsed.setNoSpec(isNoSpec);
        parsed.reset(elementList);
        ParserUtil.parseKey(parsed, clz);
    }

    private static void parseTableNameMapping(Class clz, Parsed parsed) {
        X.Mapping mapping = clz.getAnnotation(X.Mapping.class);
        if (mapping != null) {
            String tableName = mapping.value();
            if (!tableName.equals("")) {
                parsed.setTableName(tableName);
                parsed.setOriginTable(tableName);
                parsed.setNoSpec(false);
            } else {
                String name = BeanUtil.getByFirstLower(clz.getSimpleName());
                String mapper = ParserUtil.getMapper(name);
                String prefix = mappingPrefix;
                if (SqliStringUtil.isNotNull(prefix)) {
                    if (!prefix.endsWith("_")) {
                        prefix = prefix + "_";
                    }
                    mapper = prefix + mapper;
                }
                parsed.setTableName(mapper);
                parsed.setOriginTable(mapper);
            }
        } else {
            String name = BeanUtil.getByFirstLower(clz.getSimpleName());
            String mapper = ParserUtil.getMapper(name);
            String prefix = mappingPrefix;
            if (SqliStringUtil.isNotNull(prefix)) {
                if (!prefix.endsWith("_")) {
                    prefix = prefix + "_";
                }
                mapper = prefix + mapper;
            }
            parsed.setTableName(mapper);
            parsed.setOriginTable(mapper);
        }
    }

    private static void sortOnParsing(Parsed parsed, List<BeanElement> elementList) {
        BeanElement one = null;
        Iterator<BeanElement> ite = elementList.iterator();
        while (ite.hasNext()) {
            BeanElement be = ite.next();
            if (!be.getProperty().equals(parsed.getKey(1))) continue;
            one = be;
            ite.remove();
        }
        elementList.add(0, one);
        Iterator<BeanElement> beIte = parsed.getBeanElementList().iterator();
        while (beIte.hasNext()) {
            if (null != beIte.next()) continue;
            beIte.remove();
        }
    }

    public static void parse(Class clz) {
        if (clz == Criteria.class || clz == Criteria.ResultMapCriteria.class || clz == Void.class) {
            throw new IllegalArgumentException("parser unsupport Criteria, CriteriaJoinable, ....");
        }
        Parsed parsed = new Parsed(clz);
        List<BeanElement> elementList = ParserUtil.parseElementList(clz);
        Parser.parseElement(clz, parsed, elementList);
        Parser.parseTableNameMapping(clz, parsed);
        Parser.sortOnParsing(parsed, elementList);
        ParserUtil.parseCacheableAnno(clz, parsed);
        Parser.put(clz, parsed);
    }
}

