/*
 * Decompiled with CFR 0.152.
 */
package io.xream.sqli.parser;

import io.xream.sqli.exception.ParsingException;
import io.xream.sqli.parser.BeanElement;
import io.xream.sqli.util.ParserUtil;
import io.xream.sqli.util.SqliStringUtil;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class Parsed {
    private boolean isChecked = false;
    private Class clz;
    private String tableName;
    private String originTable;
    private boolean isNoSpec = true;
    private final Map<Integer, String> keyMap = new HashMap<Integer, String>();
    private final Map<Integer, Field> keyFieldMap = new HashMap<Integer, Field>();
    private List<BeanElement> beanElementList;
    private Map<String, BeanElement> elementMap = new HashMap<String, BeanElement>();
    private Map<String, String> propertyMapperMap = new HashMap<String, String>();
    private Map<String, String> mapperPropertyMapLower = new HashMap<String, String>();
    private boolean isNoCache;

    public Class getClz() {
        return this.clz;
    }

    public void setClz(Class clz) {
        this.clz = clz;
    }

    public Parsed(Class clz) {
        this.clz = clz;
    }

    public String getId() {
        return String.valueOf(this.keyMap.get(1));
    }

    public BeanElement getElement(String property) {
        return this.elementMap.get(property);
    }

    public BeanElement getElementExisted(String property) {
        BeanElement be = this.elementMap.get(property);
        if (be == null) {
            throw new ParsingException("Not exist: " + property);
        }
        return be;
    }

    public Map<String, BeanElement> getElementMap() {
        return this.elementMap;
    }

    public Map<Integer, String> getKeyMap() {
        return this.keyMap;
    }

    public boolean contains(String property) {
        return this.elementMap.containsKey(property);
    }

    public Map<Integer, Field> getKeyFieldMap() {
        return this.keyFieldMap;
    }

    public Field getKeyField(int index) {
        Field field = this.keyFieldMap.get(index);
        if (Objects.isNull(field)) {
            throw new ParsingException("No setting of PrimaryKey by @X.Key");
        }
        return field;
    }

    public boolean isAutoIncreaseId(Long keyOneValue) {
        Field keyOneField = this.getKeyField(1);
        Class<?> keyOneType = keyOneField.getType();
        return keyOneType != String.class && (keyOneValue == null || keyOneValue == 0L);
    }

    public String getKey(int index) {
        String key = this.keyMap.get(index);
        if (Objects.isNull(key)) {
            throw new ParsingException("No setting of PrimaryKey by @X.Key");
        }
        return key;
    }

    public Long tryToGetLongKey(Object obj) {
        Long keyOneValue = 0L;
        Field keyOneField = this.getKeyField(1);
        if (Objects.isNull(keyOneField)) {
            throw new ParsingException("No setting of PrimaryKey by @X.Key");
        }
        Class<?> keyOneType = keyOneField.getType();
        if (keyOneType != String.class) {
            try {
                Object keyValue = keyOneField.get(obj);
                if (keyValue != null) {
                    keyOneValue = Long.valueOf(keyValue.toString());
                }
            }
            catch (Exception e) {
                throw new ParsingException(e.getMessage());
            }
        }
        return keyOneValue;
    }

    public List<BeanElement> getBeanElementList() {
        return this.beanElementList;
    }

    public void setOriginTable(String originTable) {
        this.originTable = originTable;
    }

    public void reset(List<BeanElement> beanElementList) {
        this.beanElementList = beanElementList;
        this.propertyMapperMap.clear();
        this.elementMap.clear();
        this.mapperPropertyMapLower.clear();
        for (BeanElement e : this.beanElementList) {
            String property = e.getProperty();
            String mapper = e.getMapper();
            this.elementMap.put(property, e);
            this.propertyMapperMap.put(property, mapper);
            this.mapperPropertyMapLower.put(mapper.toLowerCase(), property);
        }
    }

    public String getTableName(String alia) {
        if (SqliStringUtil.isNullOrEmpty(alia)) {
            return this.tableName;
        }
        if (!alia.equalsIgnoreCase(this.getClzName())) {
            return alia;
        }
        return this.tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = ParserUtil.filterSQLKeyword(tableName);
    }

    public String getClzName() {
        return this.clz.getSimpleName();
    }

    public boolean isNoCache() {
        return this.isNoCache;
    }

    public void setNoCache(boolean isNoCache) {
        this.isNoCache = isNoCache;
    }

    public String getMapper(String property) {
        return this.propertyMapperMap.get(property);
    }

    public String getPropertyByLower(String mapper) {
        return this.mapperPropertyMapLower.get(mapper.toLowerCase());
    }

    public Map<String, String> getPropertyMapperMap() {
        return this.propertyMapperMap;
    }

    public boolean isNoSpec() {
        return this.isNoSpec;
    }

    public void setNoSpec(boolean isNoSpec2) {
        this.isNoSpec = isNoSpec2;
    }

    public String toString() {
        return "Parsed{, isChecked=" + this.isChecked + ", clz=" + this.clz + ", tableName='" + this.tableName + '\'' + ", originTable='" + this.originTable + '\'' + ", isNoSpec=" + this.isNoSpec + ", keyMap=" + this.keyMap + ", keyFieldMap=" + this.keyFieldMap + ", beanElementList=" + this.beanElementList + ", elementMap=" + this.elementMap + ", propertyMapperMap=" + this.propertyMapperMap + ", isNoCache=" + this.isNoCache + '}';
    }
}

