/*
 * Decompiled with CFR 0.152.
 */
package io.xream.sqli.builder;

import java.util.HashSet;
import java.util.Set;

public interface SqlNormalizer {
    public static final Set<String> OP_SET = new HashSet(){
        {
            this.add("=");
            this.add("!");
            this.add(">");
            this.add("<");
            this.add("+");
            this.add("-");
            this.add("*");
            this.add("/");
            this.add("(");
            this.add(")");
            this.add(";");
        }
    };

    default public String normalizeSql(String handwritten) {
        StringBuilder valueSb = new StringBuilder();
        boolean ignore = false;
        int length = handwritten.length();
        for (int j = 0; j < length; ++j) {
            String strEle = String.valueOf(handwritten.charAt(j));
            if (" ".equals(strEle)) {
                ignore = true;
                continue;
            }
            if (OP_SET.contains(strEle)) {
                String nextOp;
                valueSb.append(" ");
                valueSb.append(strEle);
                if (j + 1 < length && OP_SET.contains(nextOp = String.valueOf(handwritten.charAt(j + 1)))) {
                    valueSb.append(nextOp);
                    ++j;
                }
                valueSb.append(" ");
            } else {
                if (ignore) {
                    valueSb.append(" ");
                }
                valueSb.append(strEle);
            }
            ignore = false;
        }
        return valueSb.toString();
    }
}

