/*
 * Decompiled with CFR 0.152.
 */
package io.xream.sqli.builder;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.xream.sqli.api.Routeable;
import io.xream.sqli.builder.BuildingBlock;
import io.xream.sqli.builder.CriteriaCondition;
import io.xream.sqli.builder.Distinct;
import io.xream.sqli.builder.FunctionResultKey;
import io.xream.sqli.builder.KV;
import io.xream.sqli.builder.PropertyMapping;
import io.xream.sqli.builder.Reduce;
import io.xream.sqli.builder.SourceScript;
import io.xream.sqli.builder.SqlNormalizer;
import io.xream.sqli.core.Alias;
import io.xream.sqli.core.ResultMapHelper;
import io.xream.sqli.page.Paged;
import io.xream.sqli.page.Sort;
import io.xream.sqli.parser.Parsed;
import io.xream.sqli.util.BeanUtil;
import io.xream.sqli.util.SqliStringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Criteria
implements Alias,
CriteriaCondition,
Paged,
Routeable,
Serializable {
    private static final long serialVersionUID = 7088698915888081349L;
    private Class<?> clzz;
    private boolean isTotalRowsIgnored;
    private int page;
    private int rows;
    private Object routeKey;
    private List<Sort> sortList;
    private List<KV> fixedSortList = new ArrayList<KV>();
    private List<BuildingBlock> buildingBlockList = new ArrayList<BuildingBlock>();
    private String forceIndex;
    @JsonIgnore
    private transient Parsed parsed;
    @JsonIgnore
    private transient String countDistinct = "COUNT(*) count";
    @JsonIgnore
    private transient String customedResultKey = "*";

    @Override
    public Map<String, String> getAliaMap() {
        return null;
    }

    public Class<?> getClzz() {
        return this.clzz;
    }

    public void setClzz(Class<?> clz) {
        this.clzz = clz;
    }

    @Override
    public Parsed getParsed() {
        return this.parsed;
    }

    public void setParsed(Parsed parsed) {
        this.parsed = parsed;
    }

    public String sourceScript() {
        return BeanUtil.getByFirstLower(this.getClzz().getSimpleName());
    }

    public void setCountDistinct(String str) {
        this.countDistinct = str;
    }

    public String getCountDistinct() {
        return this.countDistinct;
    }

    @Override
    public List<Sort> getSortList() {
        if (this.sortList == null || this.sortList.isEmpty()) {
            return null;
        }
        Iterator<Sort> ite = this.sortList.iterator();
        while (ite.hasNext()) {
            Sort sort = ite.next();
            if (!SqliStringUtil.isNullOrEmpty(sort.getOrderBy())) continue;
            ite.remove();
        }
        return this.sortList;
    }

    public void setSortList(List<Sort> sortList) {
        this.sortList = sortList;
    }

    public void setCustomedResultKey(String str) {
        this.customedResultKey = SqliStringUtil.isNullOrEmpty(str) ? "*" : str;
    }

    public String resultAllScript() {
        return this.customedResultKey;
    }

    public List<KV> getFixedSortList() {
        return this.fixedSortList;
    }

    public void setTotalRowsIgnored(boolean totalRowsIgnored) {
        this.isTotalRowsIgnored = totalRowsIgnored;
    }

    @Override
    public boolean isTotalRowsIgnored() {
        return this.isTotalRowsIgnored;
    }

    @Override
    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    @Override
    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public String getForceIndex() {
        return this.forceIndex;
    }

    public void setForceIndex(String forceIndex) {
        this.forceIndex = forceIndex;
    }

    @Override
    public Object getRouteKey() {
        return this.routeKey;
    }

    public void setRouteKey(Object routeKey) {
        this.routeKey = routeKey;
    }

    @Override
    public List<BuildingBlock> getBuildingBlockList() {
        return this.buildingBlockList;
    }

    protected void add(BuildingBlock buildingBlock) {
        this.buildingBlockList.add(buildingBlock);
    }

    public boolean isFixedSort() {
        return !this.fixedSortList.isEmpty();
    }

    public void paged(Paged paged) {
        this.isTotalRowsIgnored = paged.isTotalRowsIgnored();
        this.page = paged.getPage();
        this.rows = paged.getRows();
        this.sortList = paged.getSortList();
    }

    public String getCacheKey() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.isTotalRowsIgnored).append(this.page).append(this.rows);
        if (this.sortList != null) {
            for (Sort sort : this.sortList) {
                sb.append(sort.getOrderBy()).append((Object)sort.getDirection());
            }
        }
        for (KV kv : this.fixedSortList) {
            sb.append(kv.k).append(kv.v);
        }
        for (BuildingBlock buildingBlock : this.buildingBlockList) {
            sb.append(buildingBlock.getConjunction()).append(buildingBlock.getPredicate()).append(buildingBlock.getKey()).append(buildingBlock.getValue());
        }
        sb.append(this.forceIndex);
        sb.append(this.clzz);
        sb.append(this.routeKey);
        return sb.toString();
    }

    public String toString() {
        return "Criteria{isTotalRowsIgnored=" + this.isTotalRowsIgnored + ", page=" + this.page + ", rows=" + this.rows + ", sortList='" + this.sortList + '\'' + ", buildingBlockList=" + this.buildingBlockList + ", forceIndex=" + this.forceIndex + ", clz=" + this.clzz + '}';
    }

    public static final class ResultMapCriteria
    extends Criteria
    implements ResultMapHelper,
    SqlNormalizer,
    Serializable {
        private static final long serialVersionUID = -2365612538012282380L;
        private List<String> resultKeyList = new ArrayList<String>();
        private List<FunctionResultKey> resultFunctionList = new ArrayList<FunctionResultKey>();
        private List<KV> resultKeyAssignedAliaList = new ArrayList<KV>();
        private String groupBy;
        private Distinct distinct;
        private String sourceScript;
        private List<SourceScript> sourceScripts = new ArrayList<SourceScript>();
        private List<Reduce> reduceList = new ArrayList<Reduce>();
        private boolean isResultWithDottedKey;
        private boolean isWithoutOptimization;
        @JsonIgnore
        private transient PropertyMapping propertyMapping;
        @JsonIgnore
        private transient Map<String, String> aliaMap = new HashMap<String, String>();
        @JsonIgnore
        private transient Map<String, String> resultKeyAliaMap = new HashMap<String, String>();

        public Distinct getDistinct() {
            return this.distinct;
        }

        public List<Reduce> getReduceList() {
            return this.reduceList;
        }

        public List<SourceScript> getSourceScripts() {
            return this.sourceScripts;
        }

        public String getGroupBy() {
            return this.groupBy;
        }

        public void setGroupBy(String groupBy) {
            if (SqliStringUtil.isNullOrEmpty(this.groupBy)) {
                this.groupBy = groupBy;
                return;
            }
            if (this.groupBy.contains(groupBy)) {
                return;
            }
            this.groupBy = this.groupBy + ", " + groupBy;
        }

        public void setDistinct(Distinct distinct) {
            this.distinct = distinct;
        }

        @Override
        public PropertyMapping getPropertyMapping() {
            return this.propertyMapping;
        }

        public void setPropertyMapping(PropertyMapping propertyMapping) {
            this.propertyMapping = propertyMapping;
        }

        @Override
        public Map<String, String> getResultKeyAliaMap() {
            return this.resultKeyAliaMap;
        }

        @Override
        public Map<String, String> getAliaMap() {
            return this.aliaMap;
        }

        public void setSourceScript(String sourceScript) {
            this.sourceScript = this.normalizeSql(sourceScript);
        }

        public List<String> getResultKeyList() {
            return this.resultKeyList;
        }

        public List<KV> getResultKeyAssignedAliaList() {
            return this.resultKeyAssignedAliaList;
        }

        public List<FunctionResultKey> getResultFunctionList() {
            return this.resultFunctionList;
        }

        @Override
        public boolean isResultWithDottedKey() {
            return this.isResultWithDottedKey;
        }

        public void setResultWithDottedKey(boolean resultWithDottedKey) {
            this.isResultWithDottedKey = resultWithDottedKey;
        }

        public boolean isWithoutOptimization() {
            return this.isWithoutOptimization;
        }

        public void setWithoutOptimization(boolean withoutOptimization) {
            this.isWithoutOptimization = withoutOptimization;
        }

        @Override
        public Class<?> getClzz() {
            return ((Criteria)this).clzz == null ? Map.class : ((Criteria)this).clzz;
        }

        @Override
        public String sourceScript() {
            if (this.sourceScript == null) {
                if (super.getClzz() == null) {
                    return null;
                }
                return BeanUtil.getByFirstLower(super.getClzz().getSimpleName());
            }
            return this.sourceScript;
        }

        public void adpterResultScript() {
            if (Objects.nonNull(((Criteria)this).customedResultKey) && !((Criteria)this).customedResultKey.equals("*")) {
                return;
            }
            int size = 0;
            String column = "";
            if (this.resultKeyList.isEmpty()) {
                column = column + " * ";
            } else {
                size = this.resultKeyList.size();
                for (int i = 0; i < size; ++i) {
                    column = column + " " + this.resultKeyList.get(i);
                    if (i >= size - 1) continue;
                    column = column + ",";
                }
            }
            ((Criteria)this).customedResultKey = column;
        }

        @Override
        public String toString() {
            return "ResultMapCriteria{resultKeyList=" + this.resultKeyList + ", sourceScript='" + this.sourceScript + '\'' + ", distinct=" + this.distinct + ", groupBy='" + this.groupBy + '\'' + ", reduceList=" + this.reduceList + ", aliaMap=" + this.aliaMap + '}';
        }
    }
}

