/*
 * Decompiled with CFR 0.152.
 */
package io.xream.sqli.builder;

import io.xream.sqli.builder.BuildingBlock;
import io.xream.sqli.builder.ConjunctionAndOtherScript;
import io.xream.sqli.builder.Criteria;
import io.xream.sqli.builder.CriteriaCondition;
import io.xream.sqli.builder.KeyMapper;
import io.xream.sqli.builder.PredicateAndOtherScript;
import io.xream.sqli.core.Alias;
import io.xream.sqli.filter.BaseTypeFilter;
import io.xream.sqli.parser.BeanElement;
import io.xream.sqli.parser.Parsed;
import io.xream.sqli.parser.Parser;
import io.xream.sqli.support.TimestampSupport;
import io.xream.sqli.util.BeanUtil;
import io.xream.sqli.util.SqliStringUtil;
import java.util.Iterator;
import java.util.List;

public interface ConditionCriteriaToSql
extends KeyMapper {
    default public void buildConditionSql(StringBuilder sb, List<BuildingBlock> buildingBlockList) {
        if (buildingBlockList == null || buildingBlockList.isEmpty()) {
            return;
        }
        for (BuildingBlock buildingBlock : buildingBlockList) {
            if (buildingBlock.getPredicate() == PredicateAndOtherScript.SUB) {
                if (buildingBlock.getSubList().isEmpty()) continue;
                buildingBlock.getSubList().get(0).setConjunction(ConjunctionAndOtherScript.NONE);
                sb.append(buildingBlock.getConjunction().sql());
                sb.append(" ").append("(").append(" ");
                this.buildConditionSql(sb, buildingBlock.getSubList());
                sb.append(" ").append(")");
                continue;
            }
            sb.append(buildingBlock.getConjunction().sql()).append(buildingBlock.getKey()).append(buildingBlock.getPredicate().sql());
            if (buildingBlock.getValue() == null) continue;
            if (buildingBlock.getPredicate() == PredicateAndOtherScript.IN || buildingBlock.getPredicate() == PredicateAndOtherScript.NOT_IN) {
                List inList = (List)buildingBlock.getValue();
                Object v = inList.get(0);
                Class<?> vType = v.getClass();
                ConditionCriteriaToSql.buildIn(sb, vType, inList);
                continue;
            }
            if (buildingBlock.getPredicate() == PredicateAndOtherScript.IS_NULL || buildingBlock.getPredicate() == PredicateAndOtherScript.IS_NOT_NULL || buildingBlock.getPredicate() == PredicateAndOtherScript.X) continue;
            sb.append("?").append(" ");
        }
    }

    public static void buildIn(StringBuilder sb, Class clz, List<? extends Object> inList) {
        sb.append("(").append(" ");
        int length = inList.size();
        if (clz == String.class) {
            for (int j = 0; j < length; ++j) {
                Object value = inList.get(j);
                if (value == null || SqliStringUtil.isNullOrEmpty(value.toString())) continue;
                value = ConditionCriteriaToSql.filter(value.toString());
                sb.append("'").append(value).append("'");
                if (j >= length - 1) continue;
                sb.append(",");
            }
        } else if (BeanUtil.isEnum(clz)) {
            for (int j = 0; j < length; ++j) {
                Object value = inList.get(j);
                if (value == null) continue;
                String ev = null;
                ev = value instanceof String ? (String)value : ((Enum)value).name();
                sb.append("'").append(ev).append("'");
                if (j >= length - 1) continue;
                sb.append(",");
            }
        } else {
            for (int j = 0; j < length; ++j) {
                Object value = inList.get(j);
                if (value == null) continue;
                sb.append(value);
                if (j >= length - 1) continue;
                sb.append(",");
            }
        }
        sb.append(" ").append(")");
    }

    public static String filter(String sql) {
        sql = sql.replace("drop", " ").replace(";", " ");
        return sql;
    }

    public static interface Pre {
        default public void pre(List<Object> valueList, List<BuildingBlock> buildingBlockList) {
            for (BuildingBlock buildingBlock : buildingBlockList) {
                if (buildingBlock.getPredicate() == PredicateAndOtherScript.SUB) {
                    this.pre(valueList, buildingBlock.getSubList());
                    continue;
                }
                if (buildingBlock.getPredicate() == PredicateAndOtherScript.X) {
                    Object value = buildingBlock.getValue();
                    if (value == null || !(value instanceof Object[])) continue;
                    for (Object v : (Object[])value) {
                        Pre.add(valueList, v);
                    }
                    continue;
                }
                if (buildingBlock.getPredicate() == PredicateAndOtherScript.IN || buildingBlock.getPredicate() == PredicateAndOtherScript.NOT_IN || buildingBlock.getPredicate() == PredicateAndOtherScript.IS_NULL || buildingBlock.getPredicate() == PredicateAndOtherScript.IS_NOT_NULL) continue;
                Object v = buildingBlock.getValue();
                Pre.add(valueList, v);
            }
        }

        public static void add(List<Object> valueList, Object value) {
            if (BeanUtil.isEnum(value.getClass())) {
                try {
                    valueList.add(((Enum)value).name());
                }
                catch (Exception exception) {}
            } else {
                valueList.add(value);
            }
        }
    }

    public static interface Filter {
        default public void filter(List<BuildingBlock> buildingBlockList, CriteriaCondition criteria, Alias alias) {
            if (buildingBlockList == null || buildingBlockList.isEmpty()) {
                return;
            }
            Iterator<BuildingBlock> ite = buildingBlockList.iterator();
            while (ite.hasNext()) {
                List<BuildingBlock> subList;
                BuildingBlock buildingBlock = ite.next();
                PredicateAndOtherScript p = buildingBlock.getPredicate();
                String key = buildingBlock.getKey();
                if (p == PredicateAndOtherScript.SUB) {
                    this.filter(buildingBlock.getSubList(), criteria, alias);
                    if (buildingBlock.getSubList().isEmpty()) {
                        ite.remove();
                    }
                } else if (p == PredicateAndOtherScript.EQ || p == PredicateAndOtherScript.NE || p == PredicateAndOtherScript.GT || p == PredicateAndOtherScript.GTE || p == PredicateAndOtherScript.LT || p == PredicateAndOtherScript.LTE) {
                    if (key.contains(".")) {
                        Parsed parsed;
                        String[] arr = key.split("\\.");
                        String alia = arr[0];
                        String clzName = alias.getAliaMap().get(alia);
                        if (clzName == null) {
                            clzName = alia;
                        }
                        if ((parsed = Parser.get(clzName)) != null) {
                            if (BaseTypeFilter.isBaseType(arr[1], buildingBlock.getValue(), parsed)) {
                                ite.remove();
                            } else {
                                BeanElement be = parsed.getElement(arr[1]);
                                TimestampSupport.testNumberValueToDate(be.getClz(), buildingBlock);
                                if (buildingBlock.getValue() == null) {
                                    ite.remove();
                                }
                            }
                        }
                    } else {
                        String ss;
                        Parsed parsed = criteria.getParsed();
                        if (parsed == null && (ss = ((Criteria.ResultMapCriteria)criteria).sourceScript()) != null) {
                            parsed = Parser.get(ss);
                        }
                        if (parsed != null) {
                            if (BaseTypeFilter.isBaseType(key, buildingBlock.getValue(), parsed)) {
                                ite.remove();
                            } else {
                                BeanElement be = parsed.getElement(key);
                                TimestampSupport.testNumberValueToDate(be.getClz(), buildingBlock);
                                if (buildingBlock.getValue() == null) {
                                    ite.remove();
                                }
                            }
                        }
                    }
                } else if (p == PredicateAndOtherScript.IN || p == PredicateAndOtherScript.NOT_IN) {
                    List valueList = (List)buildingBlock.getValue();
                    if (valueList.size() > 1) continue;
                    if (key.contains(".")) {
                        if (BaseTypeFilter.isBaseType(key, valueList.get(0), (Alias)((Object)criteria))) {
                            ite.remove();
                        }
                    } else {
                        Parsed parsed = criteria.getParsed();
                        if (parsed != null && BaseTypeFilter.isBaseType(key, valueList.get(0), parsed)) {
                            ite.remove();
                        }
                    }
                }
                if ((subList = buildingBlock.getSubList()) == null || subList.isEmpty()) continue;
                this.filter(subList, criteria, alias);
            }
        }
    }
}

