/*
 * Decompiled with CFR 0.152.
 */
package io.xream.sqli.builder;

import io.xream.sqli.builder.BuildingBlock;
import io.xream.sqli.builder.PredicateAndOtherScript;
import io.xream.sqli.builder.SqlNormalizer;
import io.xream.sqli.util.SqliStringUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class ConditionCriteriaBuilder
implements SqlNormalizer {
    private ConditionCriteriaBuilder instance;
    private transient List<BuildingBlock> buildingBlockList;
    private transient boolean isOr;
    private transient List<BuildingBlock> tempList;
    private transient List<List<BuildingBlock>> subsList = new LinkedList<List<BuildingBlock>>();

    protected ConditionCriteriaBuilder() {
        this.instance = this;
    }

    protected ConditionCriteriaBuilder(List<BuildingBlock> buildingBlockList) {
        this.instance = this;
        this.instance.buildingBlockList = buildingBlockList;
    }

    protected void init(List<BuildingBlock> buildingBlockList) {
        this.buildingBlockList = buildingBlockList;
    }

    public static ConditionCriteriaBuilder build(List<BuildingBlock> buildingBlockList) {
        return new ConditionCriteriaBuilder(buildingBlockList);
    }

    public ConditionCriteriaBuilder eq(String property, Object value) {
        return this.doGle(PredicateAndOtherScript.EQ, property, value);
    }

    public ConditionCriteriaBuilder lt(String property, Object value) {
        return this.doGle(PredicateAndOtherScript.LT, property, value);
    }

    public ConditionCriteriaBuilder lte(String property, Object value) {
        return this.doGle(PredicateAndOtherScript.LTE, property, value);
    }

    public ConditionCriteriaBuilder gt(String property, Object value) {
        return this.doGle(PredicateAndOtherScript.GT, property, value);
    }

    public ConditionCriteriaBuilder gte(String property, Object value) {
        return this.doGle(PredicateAndOtherScript.GTE, property, value);
    }

    public ConditionCriteriaBuilder ne(String property, Object value) {
        return this.doGle(PredicateAndOtherScript.NE, property, value);
    }

    public ConditionCriteriaBuilder like(String property, String value) {
        if (SqliStringUtil.isNullOrEmpty(value)) {
            this.isOr();
            return this.instance;
        }
        String likeValue = "%" + value + "%";
        return this.doLike(PredicateAndOtherScript.LIKE, property, likeValue);
    }

    public ConditionCriteriaBuilder likeRight(String property, String value) {
        if (SqliStringUtil.isNullOrEmpty(value)) {
            this.isOr();
            return this.instance;
        }
        String likeValue = value + "%";
        return this.doLike(PredicateAndOtherScript.LIKE, property, likeValue);
    }

    public ConditionCriteriaBuilder notLike(String property, String value) {
        if (SqliStringUtil.isNullOrEmpty(value)) {
            this.isOr();
            return this.instance;
        }
        String likeValue = "%" + value + "%";
        return this.doLike(PredicateAndOtherScript.NOT_LIKE, property, likeValue);
    }

    public ConditionCriteriaBuilder in(String property, List<? extends Object> list) {
        return this.doIn(PredicateAndOtherScript.IN, property, list);
    }

    public ConditionCriteriaBuilder nin(String property, List<? extends Object> list) {
        return this.doIn(PredicateAndOtherScript.NOT_IN, property, list);
    }

    public ConditionCriteriaBuilder nonNull(String property) {
        return this.doNull(PredicateAndOtherScript.IS_NOT_NULL, property);
    }

    public ConditionCriteriaBuilder isNull(String property) {
        return this.doNull(PredicateAndOtherScript.IS_NULL, property);
    }

    public ConditionCriteriaBuilder x(String sql, Object ... values) {
        if (SqliStringUtil.isNullOrEmpty(sql)) {
            this.isOr();
            return this.instance;
        }
        sql = this.normalizeSql(sql);
        BuildingBlock buildingBlock = new BuildingBlock(this.isOr());
        buildingBlock.setPredicate(PredicateAndOtherScript.X);
        buildingBlock.setKey(sql);
        buildingBlock.setValue(values);
        this.add(buildingBlock);
        return this.instance;
    }

    public ConditionCriteriaBuilder and() {
        this.isOr = false;
        return this.instance;
    }

    public ConditionCriteriaBuilder or() {
        this.isOr = true;
        return this.instance;
    }

    public ConditionCriteriaBuilder beginSub() {
        BuildingBlock buildingBlock = new BuildingBlock(this.isOr());
        buildingBlock.setPredicate(PredicateAndOtherScript.SUB);
        ArrayList<BuildingBlock> subList = new ArrayList<BuildingBlock>();
        buildingBlock.setSubList(subList);
        this.add(buildingBlock);
        this.tempList = subList;
        this.subsList.add(subList);
        return this.instance;
    }

    public ConditionCriteriaBuilder endSub() {
        this.isOr();
        int size = this.subsList.size();
        if (--size >= 0) {
            this.subsList.remove(size);
        }
        this.tempList = --size >= 0 ? this.subsList.get(size) : null;
        return this.instance;
    }

    private ConditionCriteriaBuilder doGle(PredicateAndOtherScript p, String property, Object value) {
        if (value == null) {
            this.isOr();
            return this.instance;
        }
        if (SqliStringUtil.isNullOrEmpty(value)) {
            this.isOr();
            return this.instance;
        }
        BuildingBlock buildingBlock = new BuildingBlock(this.isOr());
        buildingBlock.setPredicate(p);
        buildingBlock.setKey(property);
        buildingBlock.setValue(value);
        this.add(buildingBlock);
        return this.instance;
    }

    private ConditionCriteriaBuilder doLike(PredicateAndOtherScript p, String property, String likeWalue) {
        BuildingBlock buildingBlock = new BuildingBlock(this.isOr());
        buildingBlock.setPredicate(p);
        buildingBlock.setKey(property);
        buildingBlock.setValue(likeWalue);
        this.add(buildingBlock);
        return this.instance;
    }

    private ConditionCriteriaBuilder doIn(PredicateAndOtherScript p, String property, List<? extends Object> list) {
        if (list == null || list.isEmpty()) {
            this.isOr();
            return this.instance;
        }
        ArrayList<Object> tempList = new ArrayList<Object>();
        for (Object object : list) {
            if (Objects.isNull(object) || tempList.contains(object)) continue;
            tempList.add(object);
        }
        if (tempList.isEmpty()) {
            this.isOr();
            return this.instance;
        }
        BuildingBlock buildingBlock = new BuildingBlock(this.isOr());
        buildingBlock.setPredicate(p);
        buildingBlock.setKey(property);
        buildingBlock.setValue(tempList);
        this.add(buildingBlock);
        return this.instance;
    }

    private ConditionCriteriaBuilder doNull(PredicateAndOtherScript p, String property) {
        if (SqliStringUtil.isNullOrEmpty(property)) {
            this.isOr();
            return this.instance;
        }
        BuildingBlock buildingBlock = new BuildingBlock(this.isOr());
        buildingBlock.setPredicate(p);
        buildingBlock.setKey(property);
        buildingBlock.setValue(p);
        this.add(buildingBlock);
        return this.instance;
    }

    private boolean isOr() {
        if (this.isOr) {
            this.isOr = false;
            return true;
        }
        return false;
    }

    private void add(BuildingBlock buildingBlock) {
        if (this.tempList == null) {
            this.buildingBlockList.add(buildingBlock);
        } else {
            this.tempList.add(buildingBlock);
        }
    }
}

