/*
 * Decompiled with CFR 0.152.
 */
package io.xream.sqli.test;

import io.xream.sqli.builder.Criteria;
import io.xream.sqli.builder.CriteriaToSql;
import io.xream.sqli.builder.KV;
import io.xream.sqli.builder.SqlBuildingAttached;
import io.xream.sqli.builder.SqlBuilt;
import io.xream.sqli.builder.internal.DefaultCriteriaToSql;
import io.xream.sqli.parser.Parser;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class SqlGenerator {
    private static SqlGenerator instance;
    private static CriteriaToSql criteriaToSql;
    private static List<KV> resultMapCriteriaList;

    private SqlGenerator() {
    }

    public static SqlGenerator generator() {
        if (criteriaToSql == null) {
            criteriaToSql = DefaultCriteriaToSql.newInstance();
            instance = new SqlGenerator();
        }
        return instance;
    }

    public SqlGenerator source(Class<?> clzz) {
        Parser.parse(clzz);
        return instance;
    }

    public SqlGenerator build(String traceKey, Criteria.ResultMapCriteria resultMapCriteria) {
        KV kv = new KV(traceKey, resultMapCriteria);
        resultMapCriteriaList.add(kv);
        return instance;
    }

    public void generate(String fileName) {
        StringBuilder sb = new StringBuilder();
        for (KV kv : resultMapCriteriaList) {
            SqlBuilt sqlBuilt = new SqlBuilt();
            final ArrayList valueList = new ArrayList();
            final ArrayList sqlBuiltList = new ArrayList();
            SqlBuildingAttached sqlBuildingAttached = new SqlBuildingAttached(){

                @Override
                public List<Object> getValueList() {
                    return valueList;
                }

                @Override
                public List<SqlBuilt> getSubList() {
                    return sqlBuiltList;
                }
            };
            criteriaToSql.toSql(false, (Criteria.ResultMapCriteria)kv.getV(), sqlBuilt, sqlBuildingAttached);
            sb.append("-- Test trace: " + kv.getK()).append("\r\n");
            sb.append("-- Test value: " + valueList).append("\r\n");
            sb.append((CharSequence)sqlBuilt.getSql()).append(";").append("\r\n");
            sb.append("-- -------------------------------------------").append("\r\n").append("\r\n");
        }
        SqlGenerator.write(fileName, sb);
    }

    private static void write(String fileName, StringBuilder sb) {
        try {
            File d = new File(".sql");
            if (!d.exists()) {
                d.mkdir();
            }
            fileName = fileName.endsWith(".sql") ? fileName : fileName + ".sql";
            Files.write(Paths.get(".sql/" + fileName, new String[0]), sb.toString().getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            resultMapCriteriaList.clear();
        }
    }

    static {
        resultMapCriteriaList = new ArrayList<KV>();
    }
}

