/*
 * Decompiled with CFR 0.152.
 */
package io.xream.sqli.exception;

import io.xream.sqli.exception.QueryException;
import io.xream.sqli.exception.SqliRuntimeException;
import io.xream.sqli.parser.Parser;
import io.xream.sqli.util.SqliExceptionUtil;
import java.sql.SQLIntegrityConstraintViolationException;
import org.slf4j.Logger;

public class ExceptionTranslator {
    private ExceptionTranslator() {
    }

    public static SqliRuntimeException onRollback(Class clzz, Exception e, Logger logger) {
        String msg;
        Throwable t = SqliExceptionUtil.unwrapThrowable(e);
        logger.error(SqliExceptionUtil.getMessage(t));
        if (t instanceof SQLIntegrityConstraintViolationException && (msg = t.getMessage()).contains("cannot be null")) {
            String prefix = clzz == null ? "" : "Table of " + Parser.get(clzz).getTableName();
            throw new SqliRuntimeException(prefix + ", " + msg);
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        return new SqliRuntimeException(t);
    }

    public static QueryException onQuery(Exception e, Logger logger) {
        Throwable t = SqliExceptionUtil.unwrapThrowable(e);
        logger.error(SqliExceptionUtil.getMessage(t));
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        return new QueryException(e);
    }
}

